% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWR.R
\name{LWR}
\alias{LWR}
\title{Plot and Model Length-Weight Relationships with Optional Log Transformation}
\usage{
LWR(
  data,
  log_transform = TRUE,
  point_col = "black",
  line_col = "red",
  shade_col = "red",
  point_size = 2,
  line_size = 1,
  alpha = 0.2,
  main = "Length-Weight Relationship",
  xlab = NULL,
  ylab = NULL,
  save_output = TRUE
)
}
\arguments{
\item{data}{A data frame with at least two columns: the first for length, the second for weight.}

\item{log_transform}{Logical. Whether to apply a log-log transformation to the variables. Default is \code{TRUE}.}

\item{point_col}{Color of the data points. Default is \code{"black"}.}

\item{line_col}{Color of the regression line. Default is \code{"red"}.}

\item{shade_col}{Color for the confidence interval ribbon. Default is \code{"red"}.}

\item{point_size}{Size of the data points. Default is \code{2}.}

\item{line_size}{Size of the regression line. Default is \code{1}.}

\item{alpha}{Transparency for the confidence interval ribbon. Default is \code{0.2}.}

\item{main}{Title of the plot. Default is \code{"Length-Weight Relationship"}.}

\item{xlab}{Optional. Custom x-axis label. If \code{NULL}, a label is generated based on \code{log_transform}.}

\item{ylab}{Optional. Custom y-axis label. If \code{NULL}, a label is generated based on \code{log_transform}.}

\item{save_output}{Logical. Whether to save the plot as a PDF and the model summary as a text file. Default is \code{TRUE}.}
}
\value{
A list containing:
\item{model}{The fitted \code{lm} object}
\item{intercept}{The estimated intercept (back-transformed if log_transform = TRUE)}
\item{slope}{The estimated slope}
\item{r_squared}{R-squared value}
\item{correlation_r}{Correlation coefficient (r)}
\item{p_value}{P-value for slope}
\item{plot}{The \code{ggplot} object for further customization}
}
\description{
This function visualizes and models the relationship between length and weight
(or any two continuous variables) using linear regression. It supports both
standard and log-transformed models, producing a ggplot2-based plot with a fitted
line, optional confidence interval shading, and annotations for the regression
equation, R^2, and p-value. When save_output is TRUE, the plot and model summary
are saved to the working directory as a PDF and text file, respectively.
}
\examples{
data(LWdata, package = "aLBI")
result <- LWR(LWdata, log_transform = TRUE, save_output = FALSE)
print(result$plot)

}
