#' @title Working with Dynamic Models for Agriculture and Environment
#' @description
#' \tabular{ll}{
#' Package: \tab ZeBook\cr
#' Type: \tab Package\cr
#' Version: \tab 1.1\cr
#' Date: \tab 2018-11-08\cr
#' License: \tab LGPL-3 \cr
#' LazyLoad: \tab yes\cr
#' LazyData: \tab yes\cr
#' Depends: \tab R(>= 2.10.0)\cr
#' Imports: \tab triangle, deSolve, stats, graphics\cr
#' }
#'
#' \strong{ZeBook}
#' Working with dynamic models for agriculture and environment
#' (Working with Dynamic Crop Models)
#'
#' Linked to book \strong{Working with Dynamic Crop Models} (Elsevier), Third edition, 27 septembre 2018 by Wallach, Makowski, Jones and Brun. \url{http://www.modelia.org/moodle/course/view.php?id=61}
#'
#' A full description of the models is in the book in appendix of the book.
#'
#' Chapter numbers have changed between Second edition and Third Edition. Here the chapter numbers in the demo were changed to fit to Third edition. But all materials available in Second edition are still available in this version. 
#'
#' \strong{ACKNOWLEDGMENTS}
#' The project "Associate a level of error in predictions of models for agronomy" (CASDAR 2010-2013) and the French network "RMT modeling and agriculture", \url{http://www.modelia.org}) have contributed to the development of this R package. This project and network are lead by ACTA (French Technical Institute for Agriculture) and was funded by a grant from the Ministry of Agriculture and Fishing of France.
#'
#' \strong{Other contributions}
#' Juliette Adrian, Master2 internship (ACTA, \url{http://www.modelia.org/moodle/mod/resource/view.php?id=1027}), january-jully 2013.
#'
#' Sylvain Toulet, Master2 internship (INRA, \url{http://www.modelia.org/moodle/mod/resource/view.php?id=965}), january-jully 2012.
#'                                     
#' @name ZeBook-package
#' @aliases ZeBook
#' @docType package
#' @author  Francois Brun (ACTA)  \email{francois.brun@@acta.asso.fr}, David Makowski (INRA), Daniel Wallach (INRA), James W. Jones (U.of Florida),
#' @references Working with Dynamic Crop Models (Elsevier), Third edition
#' \url{http://www.modelia.org}
#' @keywords models agricultural agronomy crop environment methods tools evaluation uncertainty sensitivity parameter estimation bayesian assimilation
#' @import stats
#' @import graphics
#' @import deSolve
#' @import triangle
NA
