% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zimfrv.R
\name{preprocess_genedata}
\alias{preprocess_genedata}
\title{preprocess_genedata}
\usage{
preprocess_genedata(fam_file, dosage_file, region_file, gene_name)
}
\arguments{
\item{fam_file}{.fam file in PLINK format}

\item{dosage_file}{a dosage file includes dosage information of each variant for all individuals}

\item{region_file}{a file listing genetic regions where each row contains chromosome, basepairs and the name of genetic region respectively}

\item{gene_name}{a character string of the name of a gene, e.g."CEPT". The name is case-sensitive.}
}
\value{
a data frame containing genotypes for all individuals in the required format for model fitting and testing
}
\description{
Preprocess genotype files in PLINK format

This function converts PLINK format files into data frames containing genotypes information in proper format
for the model fitting and testing.
}
\examples{
data(Ex2_fam)
data(Ex2_dosage)
data(Ex2_region)
preprocess_genedata(Ex2_fam,Ex2_dosage,Ex2_region,"r2")

}
