test_that("test.workbook.existsSheet", {
  # Create workbooks
  wb.xls <- loadWorkbook("resources/testWorkbookExistsNameAndSheet.xls", create = FALSE)
  wb.xlsx <- loadWorkbook("resources/testWorkbookExistsNameAndSheet.xlsx", create = FALSE)

  # Check that the following sheets exists (*.xls)
  expect_true(existsSheet(wb.xls, "AAA"))
  expect_true(existsSheet(wb.xls, "BBB"))
  expect_true(existsSheet(wb.xls, "CCC"))

  # Check that the following do NOT exists (*.xls)
  expect_false(existsSheet(wb.xls, "DDD"))
  expect_false(existsSheet(wb.xls, "'illegal name"))
  expect_false(existsSheet(wb.xls, "%&$$-^~@afk20 235-??a?"))

  # Check that the following names exists (*.xlsx)
  expect_true(existsSheet(wb.xlsx, "AAA"))
  expect_true(existsSheet(wb.xlsx, "BBB"))
  expect_true(existsSheet(wb.xlsx, "CCC"))

  # Check that the following do NOT exists (*.xlsx)
  expect_false(existsSheet(wb.xlsx, "DDD"))
  expect_false(existsSheet(wb.xlsx, "'illegal name"))
  expect_false(existsSheet(wb.xlsx, "%&$$-^~@afk20 235-??a?"))
})
