% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.r
\name{replace.more.failures.than}
\alias{replace.more.failures.than}
\title{Rehabilitation strategy: replace pipes with too many failures}
\usage{
replace.more.failures.than(state, failures, max.costs = Inf)
}
\arguments{
\item{state}{a state list}

\item{failures}{maximal allowed number of failures}

\item{max.costs}{maximal amount of money allowed to be spent on this strategy}
}
\value{
a state list
}
\description{
Replace pipes with a high number of failures. Pipes are only
replaced if the budget remains positive.
}
\examples{
## define a strategy function that can be passed to simulate_network():
mystrategy <- . \%>\% replace.more.failures.than(max.failure=3, max.costs=20000)

## or define a more complex strategy by combining multiple strategies
## into a prioritized sequence:
mystrategy <- . \%>\%
  replace.more.failures.than(failures=2) \%>\%
  replace.n.oldest(n=3) \%>\%
  replace.n.highest.risk(n=2, prob.failure=prob.failure.exp) \%>\%
  replace.older.than(age=8) \%>\%
  replace.n.random(n=4)


}
\seealso{
\code{\link{replace.n.highest.risk}},
\code{\link{replace.n.oldest}}, \code{\link{replace.n.random}}, \code{\link{replace.older.than}},
\code{\link{do.nothing}}
}
\author{
Andreas Scheidegger
}
