% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WAnova_mc.R
\name{welch_anova.mc}
\alias{welch_anova.mc}
\title{welch_anova.mc}
\usage{
welch_anova.mc(
  means,
  sd,
  n,
  n_sim = 1000,
  sim_func = NULL,
  alpha = 0.05,
  adj = TRUE
)
}
\arguments{
\item{means}{Vector of means for each group.}

\item{sd}{Vector of standard deviations for each group.}

\item{n}{Vector of sample sizes for each group.}

\item{n_sim}{Number of simulations to perform. Defaults to 1000.}

\item{sim_func}{Function used for generating random samples. Defaults to rnorm().}

\item{alpha}{Significance level for normality and homoscedasticity tests. Defaults to 0.05.}

\item{adj}{Logical, if TRUE applies continuity correction for proportions. Defaults to TRUE.}
}
\value{
A list of class "simres" containing the proportion of simulations where
residuals are normally distributed and homoscedastic.
}
\description{
Monte Carlo simulation to assess residual normality and homoscedasticity
across multiple groups by generating simulated data based on provided means,
standard deviations, and sample sizes.
}
\examples{
\donttest{
means <- c(50, 55, 60)
sds <- c(10, 12, 15)
n <- c(30, 35, 40)
result <- welch_anova.mc(means = means, sd = sds, n = n, n_sim = 1000, alpha = 0.05)
print(result)
}

}
