% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsize.R
\name{wanova_pwr.test}
\alias{wanova_pwr.test}
\title{wanova_pwr.test}
\usage{
wanova_pwr.test(n, means, sd, power = 0.9, alpha = 0.05)
}
\arguments{
\item{n}{A numeric vector of initial sample sizes for each group.}

\item{means}{A numeric vector of the means for each group.}

\item{sd}{A numeric vector of the standard deviations for each group.}

\item{power}{Desired power of the test. Default is 0.90.}

\item{alpha}{Significance level for the test. Default is 0.05.}
}
\value{
A list containing:
\item{n}{The adjusted sample sizes for each group. If all adjusted sizes are the same, it returns a single value.}
\item{alpha}{The significance level used in the computation.}
\item{power}{The calculated power of the test, rounded to two decimal places.}
}
\description{
This function computes the approximate sample size required to achieve a desired power level for Welch's F-test in a one-way heteroscedastic ANOVA. The function takes the initial sample size, group means, and standard deviations, and iteratively determines the necessary sample size to meet the specified power and significance level.
}
\details{
The function adjusts the sample sizes iteratively until the desired power level is achieved.
It uses the F-distribution to determine critical values and compute the power of the test.
The output includes the sample size required for each group to achieve the specified power.

Reference: Levy, K. J. (1978a). Some empirical power results associated with
Welch's robust analysis of variance technique. Journal of Statistical Computation and Simulation, 8, 43-48.
}
\examples{
\donttest{
# Example usage of the wsize function
n <- c(10, 10, 10, 10)
means <- c(1, 0, 0, -1)
sd <- c(1, 1, 1, 1)
result <- wanova_pwr.test(n, means, sd, power = 0.90, alpha = 0.05)
print(result)
}

}
\seealso{
\code{\link{print.wsize}}
}
