% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WACSestim.R
\name{WACSestim}
\alias{WACSestim}
\title{Estimation of the parameters of a WACS model}
\usage{
WACSestim(
  wacsdata,
  spar = 0.7,
  trend.norm = "L2",
  rain.model = "Gamma",
  method = "MLE",
  Vsel = NULL,
  Nclusters = NULL,
  clustering = "soft",
  plot.it = FALSE,
  DIR = "./"
)
}
\arguments{
\item{wacsdata}{Data, as returned by WACSdata}

\item{spar}{Smoothing parameter for estimating annual cycle}

\item{trend.norm}{Type of norm used in for computing central tendency
and variation. Must be  \code{"L1"} or \code{"L2"}.}

\item{rain.model}{Model for precipitation. Must be \code{"Gamma"} or \code{"None"}}

\item{method}{\code{"MLE"} or \code{"MOM"}. Estimation method for the rain model.}

\item{Vsel}{Variables (other than rain) on which clustering is 
performed when \code{Vsel=NULL}, all variables are considered.}

\item{Nclusters}{Number of clusters to consider. When \code{Nclusters = NULL},
absolute best clustering is sought for wet and dry weather
states in each season (up to 4).}

\item{clustering}{Indicates whether \code{"hard"} or \code{"soft"} clustering is
considered.}

\item{plot.it}{Boolean indicating whether plots are produced}

\item{DIR}{Directory in which placing plot}
}
\value{
A list containing all parameters; see the user guide for details.
}
\description{
Estimation of the parameters of a WACS model
}
\note{
Larger values of \code{spar} produce smoother estimates. Smaller values produce less smooth estimates. \code{spar=0.7} 
is a good compromise


Soft clustering means that days have probabilities to belong to each weather state. With hard clustering, 
this probability is set to 1 to the most likely weather state and 0 to all others. Density parameter estimates 
are more robust with \code{clustering="soft"}. Clustering is done by means of the mclust package with 
\env{modelNames="VVV"}
}
\examples{
\dontrun{

 ## For an estimation with default setting 
 ThisPar  = WACSestim(ThisData)

 ## For an estimation with max. 2 dry and wet weather types per season, 
 ## and production of plots
 ThisPar  = WACSestim(ThisData, Nclusters = 1:2, plot.it = TRUE) 

 ## For an estimation with exactly 2 dry and wet weather states per season, 
 ## clustering on variables 3 and 5 only and no production of plots
 ThisPar  = WACSestim(ThisData, Nclusters = 2, Vsel = c(3,5)) 
 }


}
