#' Train Test Split
#'
#' Splits dataset into training and testing sets.
#'
#' @param X features
#' @param y labels
#' @param test_size proportion for test set
#' @param seed for random seed
#' @return list
#'
#' @details
#' Provides functionality for train_test_split operations.
#' @seealso \code{\link{VectorForgeML-package}}
#' @examples
#'   X <- matrix(rnorm(20), nrow=10)
#'   y <- sample(0:1, 10, replace=TRUE)
#'   train_test_split(X, y, test_size=0.2)
#'
#' @export
train_test_split <- function(X,y,test_size=0.2, seed=NULL){

  if(!is.null(seed))
    set.seed(seed)

  if(is.vector(X))
    X <- matrix(X, ncol=1)

  n <- nrow(X)
  idx <- sample(n)

  split <- max(2, floor(n*(1-test_size)))

  train_idx <- idx[1:split]
  test_idx  <- idx[(split+1):n]

  list(
    X_train=X[train_idx,,drop=FALSE],
    X_test =X[test_idx,,drop=FALSE],
    y_train=y[train_idx],
    y_test =y[test_idx]
  )
}
