% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_nn_corr}
\alias{find_nn_corr}
\title{Find ordered nearest neighbors based on a correlation Matrix. Assuming the
absolute value of the correlation is monotonically decreasing with distance.
Returns an n X (m + 1) matrix similar to `GpGp::find_ordered_nn`.}
\usage{
find_nn_corr(corrMat, m)
}
\arguments{
\item{corrMat}{the correlation matrix}

\item{m}{the number of nearest neighbors}
}
\value{
an n X (m + 1) matrix
}
\description{
Find ordered nearest neighbors based on a correlation Matrix. Assuming the
absolute value of the correlation is monotonically decreasing with distance.
Returns an n X (m + 1) matrix similar to `GpGp::find_ordered_nn`.
}
\examples{
library(GpGp)
library(VeccTMVN)
set.seed(123)
d <- 3
n <- 100
locs <- matrix(runif(d * n), n, d)
covparms <- c(2, 0.01, 0)
cov_mat <- GpGp::matern15_isotropic(covparms, locs)
m <- 10
NNarray_test <- GpGp::find_ordered_nn(locs, m = m)
NNarray <- find_nn_corr(cov_mat, m)
cat("Number of mismatch is", sum(NNarray != NNarray_test, na.rm = TRUE))

}
