% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{mixmat}
\alias{mixmat}
\title{Create a mixing matrix}
\usage{
mixmat(g, attrib, use_density = TRUE)
}
\arguments{
\item{g}{\pkg{igraph} graph object.}

\item{attrib}{Character string. Vertex attribute or category.}

\item{use_density}{Logical. Use edge density. Default is \code{TRUE}.}
}
\value{
A mixing matrix.
}
\description{
Function creates a mixing matrix by graph vertex attribute.
}
\note{
Mixing matrix original function written by Gary Weissman. See: https://gist.github.com/gweissman/2402741.
}
\examples{
\dontrun{
# create a mixing matrix of the demonstration network based on vertex 
# categorical attribute for political stance "vosonCA_Stance"
g <- loadPackageGraph("DividedTheyBlog_40Alist_release.graphml")

mm <- mixmat(g, "vosonCA_Stance", use_density = FALSE)
}

}
