% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBV.R
\name{moving.decomposition}
\alias{moving.decomposition}
\title{moving.decomposition -- decompose a times series into locally estimated trend and season figures}
\usage{
moving.decomposition(n, p, q.vec, m, base.period, lambda1, lambda2)
}
\arguments{
\item{n}{number of observation points (must be odd!). Internally this will be transformed to seq( -(n-1)/2, (n-1)/2, 1)}

\item{p}{maximum exponent in polynomial for trend}

\item{q.vec}{vector containing frequencies to use for seasonal component, given as integers, i.e. c(1, 3, 5) for 1/2\emph{pi, 3/2}pi, 5/2*pi (times length of base period)}

\item{m}{width of moving window}

\item{base.period}{base period in number of observations, i.e. 12 for monthly data with yearly oscillations}

\item{lambda1}{penalty weight for smoothness of trend}

\item{lambda2}{penalty weight for smoothness of seasonal component}
}
\value{
list with the following components:
\itemize{
\item{W1}{nxn matrix of weights. Trend is estimated as W1 \%\emph{\% y, if y is the data vector}
\item{W2}{nxn matrix of weights. Season is estimated as W2 \%}\% y, if y is the data vector}
}
}
\description{
moving.decomposition -- decompose a times series into locally estimated trend and season figures
}
\note{
lambda1 == lambda2 == Inf result in estimations of the original Berliner Verfahren
}
\examples{
### Usage of moving.decomposition

t <- 1:121 # equidistant time points, i.e. 5 days

m <- 11

p <- 2     # maximally quadratic
q <- c(1, 3, 5)   # 'seasonal' components within the base period
base.period <- 24 # i.e. hourly data with daily cycles
l1 <- 1    
l2 <- 1

m.dec <- moving.decomposition( length(t), p, q, m, base.period, l1, l2)
}
