% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBV.R
\name{decomposition}
\alias{decomposition}
\title{decomposition - decompose a time series with VBV}
\usage{
decomposition(t.vec, p, q.vec, base.period, lambda1, lambda2)
}
\arguments{
\item{t.vec}{vector of observation points.}

\item{p}{maximum exponent in polynomial for trend}

\item{q.vec}{vector containing frequencies to use for seasonal component,
given as integers, i.e. c(1, 3, 5) for 1/2\emph{pi, 3/2}pi, 5/2*pi (times length of base period)}

\item{base.period}{base period in number of observations, i.e. 12 for monthly data with yearly oscillations}

\item{lambda1}{penalty weight for smoothness of trend}

\item{lambda2}{penalty weight for smoothness of seasonal component
(lambda1 == lambda2 == Inf result in estimations of the original Berliner Verfahren)}
}
\value{
list with the following components:
\itemize{
\item{trend}{A function which returns the appropriate weights if applied to a point in time}
\item{saison}{A function which returns the appropriate weights if applied to a point in time}
\item{A, G1, G2}{Some matrices that allow to calclate SSE etc. Exposed only to reuse their calculation. See the referenced paper for details.}
}
}
\description{
decomposition - decompose a time series with VBV
}
\examples{
### Usage of decomposition
t <- 1:121 # equidistant time points, i.e. 5 days
p <- 2     # maximally quadratic
q <- c(1, 3, 5)   # 'seasonal' components within the base period
base.period <- 24 # i.e. hourly data with daily cycles
l1 <- 1    
l2 <- 10

dec <- decomposition( t, p, q, base.period, l1, l2)
### Note: decomosition is independent of data, only depends on time
}
