% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datavisit.R
\name{datavisit}
\alias{datavisit}
\title{Extract subset of data using different methods}
\usage{
datavisit(data, inq)
}
\arguments{
\item{data}{A data.frame with structured column names.}

\item{inq}{An argument to determine the subset to be extracted by column names. A tensor, array, double list, integer vector and
vector binary tree is available format of \code{inq}.}
}
\value{
Return a list which contains the item index, column name, column coordinate and the data in corresponding column for each
element contained in the assignment of \code{inq}.
}
\description{
Extract the subset of data by column names using tensor, array, double list, integer vector, or vector binary tree.
}
\examples{
#View the data to be visited:
summary(datatest)
colnames(datatest)

#Structurize colnames of data into vector binary tree:
dl <- chrvec2dl(colnames(datatest))
vbt <- dl2vbt(dl)
vbt

#Setting subset in different forms, for example the pattern
#"Strain-(900~1100)-(0.01, 1)-0.6" is desired:
subunregdl <- list(c(1), c(1:5), c(2,4), c(1)) # undefined double list
subregdl <- advbtinq(vbt, subunregdl) # regularized double list
subvbt <- dl2vbt(subregdl) # sub vector binary tree
subts <- vbt2ts(subvbt) # tensor
subarr <- vbt2arr(subvbt) # array
subchrvec <- as.vector(subarr) # character vector

#Visit the data through different methods:
datavisit(datatest, subunregdl) # by handmade double list
datavisit(datatest, subregdl) # by defined double list
datavisit(datatest, subvbt) # by vector binary tree
datavisit(datatest, subts) # by tensor
datavisit(datatest, subarr) # by array
datavisit(datatest, subchrvec) # by character vector
}
\seealso{
\code{\link[VBTree:vbtinq]{vbtinq}}, \code{\link[VBTree:advbtinq]{advbtinq}}, \code{\link[VBTree:trvseleinq]{trvseleinq}},
\code{\link[VBTree:trvsidxinq]{trvsidxinq}}, \code{\link[VBTree:trvssubinq]{trvssubinq}}.
}
\keyword{Double.List}
\keyword{Vector.Binary.Tree}
\keyword{array}
\keyword{data.frame}
\keyword{tensor}
\keyword{vector}
