% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{VAR_cpDetect_Online}
\alias{VAR_cpDetect_Online}
\title{VAR_cpDetect_Online: Sequential change point Detection for Vector Auto-Regressive Models}
\usage{
VAR_cpDetect_Online(
  data,
  n0,
  w,
  alpha,
  h,
  RLmode = TRUE,
  needRefine = TRUE,
  refineSize = 1/5,
  needRefineCorrection = TRUE
)
}
\arguments{
\item{data}{A matrix where rows represent different dimensions (features) and columns represent observations. The first \code{n0} columns are treated as historical data.}

\item{n0}{Integer. The size of the historical data (number of columns in \code{data} treated as historical).}

\item{w}{Integer. The size of the sliding window used for calculating test statistics; referred to as the pre-specified detection delay.}

\item{alpha}{Numeric. The desired false alarm rate, where 1/alpha represents the targeted average run length (ARL), which should exceed the length of the data to be monitored.}

\item{h}{Integer. The order of the VAR process.}

\item{RLmode}{Logical. If \code{TRUE}, the algorithm terminates when the first alarm is issued.}

\item{needRefine}{Logical. If \code{TRUE}, a refinement process is conducted to pinpoint the change point location.}

\item{refineSize}{Numeric. The proportion of the new window size to the original window size, used during refinement.}

\item{needRefineCorrection}{Logical. If \code{TRUE}, a confirmation step is performed during the refinement process to verify the detected change point.}
}
\value{
A list containing:
\describe{
\item{\code{RL}}{The index (ignoring historical data) of the last observation read by the algorithm when the first alarm is issued. This is returned only if \code{RLmode = TRUE}.}
\item{\code{cp_refined}}{The refined estimate for the location (ignoring historical data) of the change point. This is returned only if \code{RLmode = TRUE} and \code{needRefine = TRUE}.}
\item{\code{alarm_locations}}{A vector of indices (ignoring historical data) where alarms were raised. This is returned only if \code{RLmode = FALSE}.}
\item{\code{cp_locations}}{A vector of refined change point locations (ignoring historical data), corresponding 1-to-1 with the \code{alarm_locations}. This is returned only if \code{RLmode = FALSE} and \code{needRefine = TRUE}.}
}
}
\description{
This function performs sequential change point detection in high-dimensional time series data modeled as a Vector Auto-Regressive (VAR) process, targeting changes in the transition matrices that encode temporal and cross-correlations.
}
\details{
This function fits a VAR model to the historical data using the l1 penalty and calculates test statistics for the sliding window to detect change points. If refinement is enabled, a second step narrows down the change point location. Optionally, a correction step can verify the detected change points.
}
\examples{
library(MASS)
set.seed(2024)
As <- list(matrix(c(0.5, 0.2, 0.1, 0.4), 2, 2))
As_new <- list(matrix(c(-0.5, 0.2, 0.1, -0.4), 2, 2))
Sig <- diag(2)
data_IC <- generateVAR(n = 400, As = As, Sig = Sig, h = 1)
data_OC <- generateVAR(n = 100, As = As_new, Sig = Sig, h = 1,
                       isOldProvided = TRUE, oldxs = data_IC[, ncol(data_IC)])
data <- cbind(data_IC, data_OC)
result <- VAR_cpDetect_Online(data, n0 = 300, w = 20, alpha = 1/200, h = 1,
                              RLmode = TRUE, needRefine = TRUE, refineSize = 1/5,
                              needRefineCorrection = TRUE)
print(result)

}
