% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_frequency_acum.R
\name{relative_acum_frequency}
\alias{relative_acum_frequency}
\title{Relative Accumulated Frequency Function}
\usage{
relative_acum_frequency(v = NULL, x = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{v}{Optional numeric vector (not needed for interactive mode)}

\item{x}{Optional numeric value to count (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The relative accumulated frequency of x in v (for non-interactive mode)
}
\description{
This function calculates the relative accumulated frequency of a value in a numeric vector.
}
\examples{
data <- c(1,4,3,3,2,5,7,12,1,2,3,12)
value <- 12

# Simple calculation
relative_acum_frequency(data, value)

# Learning mode
relative_acum_frequency(data, value, learn = TRUE)

# Interactive mode
if(interactive()){
relative_acum_frequency(interactive = TRUE)
}

}
