% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit1ts.R
\name{fit1ts}
\alias{fit1ts}
\title{Fit a smooth hazard model with one time scale}
\usage{
fit1ts(
  data1ts = NULL,
  y = NULL,
  r = NULL,
  Z = NULL,
  bins = NULL,
  Bbases_spec = list(),
  Wprior = NULL,
  pord = 2,
  optim_method = c("ucminf", "grid_search", "LMMsolver"),
  optim_criterion = c("aic", "bic"),
  lrho = 0,
  ridge = 0,
  control_algorithm = list(),
  par_gridsearch = list()
)
}
\arguments{
\item{data1ts}{(optional) an object created by the function
\code{prepare_data()}. Providing this input is the easiest way to use the function
\code{fit1ts}. However, the user can also provide the input data together with
a list of bins, as explained by the following parameters' descriptions.}

\item{y}{A vector of event counts of length ns, or an array of dimension ns
by n.}

\item{r}{A vector of exposure times of length ns, or an array of dimension ns
by n.}

\item{Z}{(optional) A regression matrix of covariates of dimension n by p.}

\item{bins}{a list with the specification for the bins. This is created by
the function \code{prepare_data}. Alternatively, a list with the following elements
can be provided:
* \code{bins_s} is a vector of intervals for the time scale \code{s}.
* \code{mids} is a vector with the midpoints of the intervals over \code{s}.
* \code{ns} is the number of bins over \code{s}.}

\item{Bbases_spec}{A list with the specification for the B-splines basis
with the following elements:
\itemize{
\item \code{bdeg} The degree of the B-splines basis. Default is 3 (for cubic B-splines).
\item \code{nseg_s} The number of segments for the B-splines over \code{s}. Default is 10.
\item \code{min_s} (optional) The lower limit of the domain of \code{Bs}.
Default is \code{min(bins_s)}.
\item \code{max_s} (optional) The upper limit of the domain of \code{Bs}.
Default is \code{max(bins_s)}.
}}

\item{Wprior}{An optional vector of a-priori weights.}

\item{pord}{The order of the penalty. Default is 2.}

\item{optim_method}{The method to be used for optimization:
\code{"ucminf"} (default) for the numerical optimization of the AIC (or BIC),
\code{"grid_search"} for a grid search of the minimum AIC (or BIC)
over a grid of \eqn{\log_{10}(\varrho_s)} values, and \code{"LMMsolver"} to solve the model
as sparse linear mixed model using the package LMMsolver.}

\item{optim_criterion}{The criterion to be used for optimization:
\code{"aic"} (default) or \code{"bic"}. BIC penalized model complexity more strongly
than AIC, so that its usage is recommended when a smoother fit is preferable
(see also Camarda, 2012).}

\item{lrho}{A number if \code{optim_method == "ucminf"}, default is 0.
A vector of values for \eqn{\log_{10}(\varrho_s)}  if \code{optim_method == "grid_search"}.
In the latter case, if a vector is not provided, a default sequence of
values is used for \eqn{\log_{10}(\varrho_s)} .}

\item{ridge}{A ridge penalty parameter: default is 0.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}

\item{par_gridsearch}{A list of parameters for the grid_search:
\itemize{
\item \code{plot_aic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the AIC values
over the grid of \code{log_10(rhos)} values.
\item \code{plot_bic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the BIC values
over the grid of \code{log_10(rhos)} values.
\item \code{return_aic} A Boolean. Default is \code{TRUE}. Return the AIC values.
\item \code{return_bic} A Boolean. Default is \code{TRUE}. Return the BIC values.
\item \code{mark_optimal} A Boolean. Default is \code{TRUE}. If the plot of the AIC or BIC
values is returned, marks the optimal \code{log_10(rho_s)} in the plot.
\item \code{main_aic} The title of the AIC plot. Default is \code{"AIC grid"}.
\item \code{main_bic} The title of the BIC plot. Default is \code{"BIC grid"}.
}}
}
\value{
An object of class \code{haz1ts}, or of class \code{haz1tsLMM}.
For objects of class \code{haz1ts} this is
\itemize{
\item \code{optimal_model} A list with:
\itemize{
\item \code{alpha} The vector of estimated P-splines coefficients of length \eqn{cs}.
\item \code{SE_alpha} The vector of estimated Standard Errors for the \code{alpha} coefficients,
of length \eqn{cs}.
\item \code{beta} The vector of estimated covariate coefficients of length \eqn{p}
(if model with covariates).
\item \code{se_beta} The vector of estimated Standard Errors for the
\code{beta} coefficients of length \eqn{p} (if model with covariates).
\item \code{eta} or \code{eta0}. The vector of values of the (baseline) linear predictor
(log-hazard) of length \eqn{ns}.
\item \code{H} The hat-matrix.
\item \code{Cov} The full variance-covariance matrix.
\item \code{deviance} The deviance.
\item \code{ed} The effective dimension of the model.
\item \code{aic} The value of the AIC.
\item \code{bic} The value of the BIC.
\item \code{Bbases} a list with the B-spline basis \code{Bs} (this is a list for
compatibility with functions in 2d).
}
\item \code{optimal_logrho} The optimal value of \code{log10(rho_s)}.
\item \code{P_optimal} The optimal penalty matrix P.
\item \code{AIC} (if \code{par_gridsearch$return_aic == TRUE}) The vector of AIC values.
\item \code{BIC} (if \code{par_gridsearch$return_bic == TRUE}) The vector of BIC values.
}

Objects of class \code{haz1tsLMM} have a slight different structure. They are
a list with:
\itemize{
\item \code{optimal_model} an object of class \code{LMMsolve}
\item \code{AIC_BIC} a list with, among other things, the AIC and BIC values and the
ED of the model
\item \code{n_events} the number of events
\item \code{ns} the number of bins over the s-axis
\item \code{cs} the number of B-splines over the s-axis
\item \code{covariates} an indicator for PH model
}
}
\description{
\code{fit1ts()} fits a smooth hazard model with one time scale.

Three methods are implemented for the search of the optimal smoothing
parameter (and therefore optimal model): a numerical optimization of the
AIC or BIC of the model, a search for the minimum AIC or BIC of the
model over a grid of \eqn{\log_{10}} values for the smoothing parameter and the
estimation using a sparse mixed model representation of P-splines.
Construction of the B-splines basis and of the penalty matrix is
incorporated within the function. If a matrix of covariates is provided,
the function will estimate a model with covariates.
}
\details{
Some functions from the R-package \code{LMMsolver} are used here.
We refer the interested readers to https://biometris.github.io/LMMsolver/
for more detail on \code{LMMsolver} and its usage.
}
\examples{
## preparing data - no covariates
dt1ts <- prepare_data(data = reccolon2ts,
                      s_in = "entrys",
                      s_out = "timesr",
                      events = "status",
                      ds = 180)

## fitting the model with fit1ts() - default options, that is ucminf optimization

mod1 <- fit1ts(dt1ts)

## fitting with LMMsolver
mod2 <- fit1ts(dt1ts,
              optim_method = "LMMsolver")

## preparing the data - covariates

dt1ts_cov <- prepare_data(data = reccolon2ts,
                      s_in = "entrys",
                      s_out = "timesr",
                      events = "status",
                      ds = 180,
                      individual = TRUE,
                      covs = c("rx", "node4", "sex"))

## fitting the model with fit1ts() - grid search over only two log_10(rho_s) values

mod3 <- fit1ts(dt1ts_cov,
               optim_method = "grid_search",
               lrho = c(1, 1.5))


}
\references{
Boer, Martin P. 2023. “Tensor Product P-Splines Using a Sparse Mixed Model Formulation.”
Statistical Modelling 23 (5-6): 465–79. https://doi.org/10.1177/1471082X231178591.#'
}
