
# Load the package
library(Ts)
library(terra)

# Paths to example rasters included in the package
albedo_path <- system.file("extdata", "albedo_mini.tif", package = "Ts")
ndvi_path   <- system.file("extdata", "ndvi_mini.tif", package = "Ts")
Ta_path     <- system.file("extdata", "Ta_mini.tif", package = "Ts")

# Check if the files exist
stopifnot(file.exists(albedo_path), file.exists(ndvi_path), file.exists(Ta_path))

# Load the rasters
albedo <- rast(albedo_path)
ndvi   <- rast(ndvi_path)
Ta     <- rast(Ta_path)

# Define output path
output_path_Ts <- "path_to_output_Ts.tif"

# Calculate Ts
calculate_Ts(
  albedo = albedo,
  ndvi   = ndvi,
  Ta     = Ta,
  output_path = output_path_Ts,
  verbose = TRUE
)

# Verify output
stopifnot(file.exists(output_path_Ts))
message("Ts calculation completed successfully.")
