\name{TripleR-package}
\alias{TripleR-package}
\alias{TripleR}
\docType{package}
\title{Triple R: A Package for Round-Robin Analyses Using R}
\description{
Social Relation Model (SRM) analyses for single or multiple round-robin groups are performed. These analyses are either based on one manifest variable, one latent construct measured by two manifest variables, two manifest variables and their bivariate relations, or bivariate relations between two latent constructs each measured by two manifest variables.
}

\details{
For further information of usage see \code{\link{RR}} or the built in pdf document `How to use TripleR'. You can browse all included vignettes by opening the index of the package documentation (scroll down to the very end of this page and click on `Index'; than click on `Overview of user guides and package vignettes').

If you use this package in your research, please cite it as:
Schönbrodt, F. D., Back, M. D., & Schmukle, S. C. (2012). TripleR: An R package for social relations analyses based on round-robin designs. \emph{Behavior Research Methods, 44}, 455–470. doi:10.3758/s13428-011-0150-4
}

\author{Felix D. Schönbrodt, Mitja D. Back, & Stefan C. Schmukle
}
\references{
Further information on SRM and its application:
\itemize{  
\item{Back, M. D., Schmukle, S. C. & Egloff, B. (2011). A closer look at first sight: Social relations lens model analyses of personality and interpersonal attraction at zero acquaintance. \emph{European Journal of Personality, 25}, 225-238. doi:10.1002/per.790}

\item{Bond, C. F., Jr., & Lashley, B. R. (1996). Round-robin analysis of social interaction: Exact and estimated standard errors. \emph{Psychometrika, 61}, 303-311. doi:10.1007/BF02294341}

\item{Bonito, J. A., & Kenny, D. A. (2010). The measurement of reliability of social relations components from round-robin designs. \emph{Personal Relationships, 17}, 235 - 251. doi:10.1111/j.1475-6811.2010.01274.x}

\item{Kenny, D. A. (1994). \emph{Interpersonal perception: A social relations analysis}. New York: Guilford Press.}

\item{Kenny, D. A., & La Voie, L. J. (1984). The social relations model. In L. Berkowitz (Ed.),\emph{ Advances in experimental social psychology} (Vol. 18, pp. 142-182). San Diego, CA: Academic Press.}

\item{Kwan, V. S. Y., John, O. P., Kenny, D. A., Bond, M. H., & Robins, R. W. (2004). Reconceptualizing individual differences in self-enhancement bias: An interpersonal approach. \emph{Psychological Review, 111}, 94–110. doi:10.1037/0033-295X.111.1.94}

\item{Lashley, B. R., & Bond, C. F., Jr. (1997). Significance testing for round robin data. \emph{Psychological Methods}, \emph{2}, 278-291. doi:10.1037/1082-989X.2.3.278 }

\item{Lashley, B. R. & Kenny, D. A. (1998). Power estimation in social relations analyses. \emph{Psychological Methods, 3}, 328-338. doi:10.1037/1082-989X.3.3.328}
}
}

\keyword{package}