% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series3.R
\name{Series3}
\alias{Series3}
\title{Tri-Hierarchical IBDs using Rectangular Association Scheme}
\usage{
Series3(
  m,
  n,
  D1 = FALSE,
  D2 = FALSE,
  D3 = FALSE,
  D4 = FALSE,
  D5 = FALSE,
  D6 = FALSE,
  Randomization = FALSE
)
}
\arguments{
\item{m}{Any integer >=3}

\item{n}{Any integer >=3}

\item{D1}{Bi-Hierarchical IBD by ignoring blocks}

\item{D2}{Bi-Hierarchical IBD by ignoring sub-blocks}

\item{D3}{Bi-Hierarchical IBD by ignoring sub-sub blocks}

\item{D4}{IBD at block level}

\item{D5}{IBD at sub block level}

\item{D6}{IBD at sub-sub block level}

\item{Randomization}{Randomization of layout of the designs if needed enter TRUE; by default it is FALSE.}
}
\value{
It gives Tri-HIB design and six component designs with canonical efficiency factor in comparison to an orthogonal design.
}
\description{
This function provides the Tri-Hierarchical IBDs based on Rectangular association scheme. Here,  v= m*n, v should be composite number and (m,n)>=3. We find balanced incomplete block designs (BIBD) at block level and rectangular PBIB designs at sub-block level as well as sub-sub block level. Information matrix pertaining to the estimation of treatments effects, canonical efficiency factor in comparison to an orthogonal design and six component designs are provided.
}
\note{
Numbers in the outer most parentheses represents as block elements, second level parentheses as sub block elements and inner most parentheses as sub-sub block elements.
}
\examples{
library(Tri.Hierarchical.IBDs)
Series3(4,3,D1=TRUE,D2=TRUE, D3=TRUE, D4=TRUE,D5=FALSE,D6=TRUE,Randomization=TRUE)
}
\references{
Preece, D.A. (1967) <https://doi.org/10.1093/biomet/54.3-4.479>."Nested balanced incomplete block designs".
}
