% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{chi.stat}
\alias{chi.stat}
\title{chi.stat function}
\usage{
chi.stat(ftab)
}
\arguments{
\item{ftab}{it is a matrix with dimension 2 by \eqn{K}.}
}
\value{
chi.val, a chisuqre type of statistics value
}
\description{
This function calculates the $M$ statistics value as defined in the reference paper.
}
\details{
The \eqn{M} statistics is defined as: \deqn{M=\sum_{l=1}^{K}\left(\frac{(O_{x,l}-E_{x,l})^2}{E_{x,l}}+\frac{(O_{x,l}-E_{x,l})^2}{\left(n_ln_{l+1}-E_{x,l}\right)}\right)+\sum_{l=1}^{K}\left(\frac{(O_{y,l}-E_{y,l})^2}{E_{y,l}}+\frac{(O_{y,l}-E_{y,l})^2}{\left(m_lm_{l+1}-E_{y,l}\right)}\right).}
}
\examples{
chi.stat(ftab=rbind(c(20,10,20),c(15,15,20)))
}
\references{
Wang, Y., Stapleton, A. E., & Chen, C. (2018). Two-sample nonparametric stochastic order inference with an application in plant physiology. Journal of Statistical Computation and Simulation, 88(14), 2668-2683.
}
