% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TsoilFunctions.R
\name{soil_temperature_equation}
\alias{soil_temperature_equation}
\title{Core Function Called to Solve Equation for Soil Temperature}
\usage{
soil_temperature_equation(L, rho_a, c_a, u_inst, z_r, z0, T_inst, T_s)
}
\arguments{
\item{L}{\code{numeric} Monin-Obukhov length, a measure of the instability of heat flow (see \insertCite{Beckman1973;textual}{TrenchR}).}

\item{rho_a}{\code{numeric} density of air (\ifelse{html}{\out{kg m<sup>-3</sup>}}{\eqn{kg m^-3}{ASCII}}).}

\item{c_a}{\code{numeric} specific heat of air (\ifelse{html}{\out{J kg<sup>-1</sup> C<sup>-1</sup>}}{\eqn{J kg^-1 C^-1}{ASCII}}).}

\item{u_inst}{\code{numeric} instantaneous wind speed (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}).}

\item{z_r}{\code{numeric} reference height (m).}

\item{z0}{\code{numeric} surface roughness (m).}

\item{T_inst}{\code{numeric} instantaneous air temperature (C).}

\item{T_s}{\code{numeric} initial soil surface temperature (C).}
}
\value{
\code{numeric} soil temperature (C).
}
\description{
The function called by \code{\link{soil_temperature_function}} to solve equation for soil temperature from \insertCite{Beckman1973;textual}{TrenchR}.
}
\examples{
  soil_temperature_equation(L      = -10, 
                            rho_a  = 1.177, 
                            c_a    = 1006, 
                            u_inst = 0.3, 
                            z_r    = 1.5, 
                            z0     = 0.02, 
                            T_inst = 8, 
                            T_s    = 20)

}
\references{
\insertAllCited{}
}
\seealso{
Other soil temperature functions: 
\code{\link{soil_conductivity}()},
\code{\link{soil_specific_heat}()},
\code{\link{soil_temperature_function}()},
\code{\link{soil_temperature_integrand}()},
\code{\link{soil_temperature}()}
}
\author{
Joseph Grigg
}
\concept{soil temperature functions}
