% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{MatrixToPhyDat}
\alias{MatrixToPhyDat}
\alias{PhyDatToMatrix}
\title{Convert between matrices and \code{phyDat} objects}
\usage{
MatrixToPhyDat(tokens, tipLabels = rownames(tokens))

PhyDatToMatrix(
  dataset,
  ambigNA = FALSE,
  inappNA = ambigNA,
  parentheses = c("{", "}"),
  sep = ""
)
}
\arguments{
\item{tokens}{Matrix of tokens, possibly created with \code{\link[=ReadCharacters]{ReadCharacters()}}
or \code{\link[=ReadTntCharacters]{ReadTntCharacters()}}.
Row names should correspond to leaf labels; column names may optionally
correspond to character labels.}

\item{tipLabels}{Optionally, an object providing labels for leaves, via
\code{\link[=TipLabels]{TipLabels()}}; will override \code{rownames(tokens)}.}

\item{dataset}{A dataset of class \code{phyDat}.}

\item{ambigNA, inappNA}{Logical specifying whether to denote ambiguous /
inapplicable characters as \code{NA} values.}

\item{parentheses}{Character vector specifying style of parentheses
with which to enclose ambiguous characters. \code{c("[", "]")} or \code{"[]"} will
render \verb{[01]}.
\code{NULL} will use the token specified in the \code{phyDat} object; but beware that
this will be treated as a distinct (non-ambiguous) token if re-encoding with
\code{PhyDatToMatrix()}.}

\item{sep}{Character with which to separate ambiguous tokens, e.g. \code{','}
will render \verb{[0,1]}.}
}
\value{
\code{MatrixToPhyDat()} returns an object of class \code{phyDat}.

\code{PhyDatToMatrix()} returns a matrix corresponding to the
uncompressed character states within a \code{phyDat} object.
}
\description{
\code{MatrixToPhyDat()} converts a matrix of tokens to a \code{phyDat} object;
\code{PhyDatToMatrix()} converts a \code{phyDat} object to a matrix of tokens.
}
\examples{
tokens <- matrix(c(0, 0, "0", 0, 0,
                   0, 0, "1", 0, 1,
                   0, 0, "1", 0, 1,
                   0, 0, "2", 0, 1,
                   1, 1, "-", 1, 0,
                   1, 1, "2", 1, "{01}"),
                   nrow = 6, ncol = 5, byrow = TRUE,
                   dimnames = list(
                     paste0("Taxon_", LETTERS[1:6]),
                     paste0("Char_", 1:5)))
                   
MatrixToPhyDat(tokens)
data("Lobo", package = "TreeTools")
head(PhyDatToMatrix(Lobo.phy)[, 91:93])
}
\seealso{
Other phylogenetic matrix conversion functions: 
\code{\link{Decompose}()},
\code{\link{Reweight}()},
\code{\link{StringToPhyDat}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{phylogenetic matrix conversion functions}
