% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_scalar_date}
\alias{check_scalar_date}
\alias{assert_scalar_date}
\title{Vérifie la conformité d'une date scalaire}
\usage{
check_scalar_date(x)

assert_scalar_date(x, add = NULL, .var.name = checkmate::vname(x))
}
\arguments{
\item{x}{un objet de type \code{Date}.}

\item{add}{Collection pour stocker les messages d'erreurs (Default is NULL)}

\item{.var.name}{Nom de l'objet à vérifier pour afficher dans les messages}
}
\value{
En sortie la fonction retourne l'objet \code{x} de manière invisible ou
une erreur.
}
\description{
Vérifie la conformité d'une date scalaire
}
\details{
On vérifie que l'objet \code{x} en entrée est bien au format \code{Date} et qu'il
s'agit d'un scalaire (vecteur de taille 1).
Cette fonction s'appuie essentiellement sur la fonction
\code{checkmate::assert_date}.

Selon le préfixe de la fonction :
\itemize{
\item si le check réussi :
\itemize{
\item la fonction \code{assert_scalar_date} retourne l'objet \code{x} de manière
invisible;
\item la fonction \code{check_scalar_date} retourne le booléen \code{TRUE}.
}
\item si le check échoue :
\itemize{
\item la fonction \code{assert_scalar_date} retourne un message d'erreur;
\item la fonction \code{check_scalar_date} retourne la chaîne de caractère
correspondante à l'erreur du check.
}
}
}
\examples{

assert_scalar_date(as.Date("2018-01-24"))
assert_scalar_date(as.Date("2000-02-29"))
assert_scalar_date(Sys.Date())

check_scalar_date(as.Date("2018-01-24"))
check_scalar_date(as.Date("2000-02-29"))
check_scalar_date(Sys.Date())

# Avec des erreurs

check_scalar_date(2L)
check_scalar_date(seq(from = as.Date("2000-01-01"), to = Sys.Date(), by =
"year"))

}
