% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tooth2Dmap.R
\name{Tooth2Dmap}
\alias{Tooth2Dmap}
\title{Tooth2Dmap}
\usage{
Tooth2Dmap(
  tooth.shape,
  input,
  rem.out = FALSE,
  fac.out = 0.5,
  smooth = FALSE,
  scale = TRUE,
  smooth.iter = 5,
  gamMap = FALSE,
  nrow = 120,
  ncol = 80,
  gdl = 250,
  method = "equiangular",
  plot = TRUE,
  pal = blue2green2red(101),
  aspect = 0.6,
  labels = c("Li", "Mes", "Bu", "D", "Li"),
  ylab = ""
)
}
\arguments{
\item{tooth.shape}{list: output from the function ToothShape}

\item{input}{list: output from the function ToothAlignment}

\item{rem.out}{logical: if TRUE outliers will be removed}

\item{fac.out}{numeric: parameter to set the threshold in outlier detection}

\item{smooth}{logical: if TRUE a smoothing filter is applied}

\item{scale}{logical: if TRUE the thichkness matrix is scaled from 0 to 1}

\item{smooth.iter}{numeric: number of smoothing iterations}

\item{gamMap}{logical: if TRUE gam smoothing is applied}

\item{nrow}{numeric: number of rows for gam smoothing matrix}

\item{ncol}{numeric: number of columns for gam smoothing matrix}

\item{gdl}{numeric: number of degree of freedom for gam smoothing matrix}

\item{method}{character: if set on "equiangular" the dentine or enamel thickness is meant as the distance of the segment intersecting the external and internal outline starting from the centroid of the section. If set on "closest" the dentine or enamel thickness is calculated at each point as the closest distance between external and internal outlines}

\item{plot}{logical: if TRUE the 2D morphometric map is plotted}

\item{pal}{character vector: colors to be used in the map production}

\item{aspect}{numeric: axis ratio for 2D morphometric map}

\item{labels}{character vector: names for x labels in the morphometric map}

\item{ylab}{character vector: label for y axis in the morphometric map}
}
\value{
dataframe dataframe for colormap production

2Dmap thickness color map

gamoutput output from GAM

data input used to build the GAM map
}
\description{
Create 2D morphometric maps of enamel/dentin thickness
}
\examples{
\donttest{
data("URI1_tooth")
require(morphomap)
Enamel<-URI1_tooth$mesh1
Dentin<-URI1_tooth$mesh2
Pulp<-URI1_tooth$mesh3
outline<-URI1_tooth$outline
set<-URI1_tooth$set
#Map of the crown
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "c")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh1$mesh
Internal<-AlignMeshes$almesh2$mesh
#Define 16 cross-sections from the 30\% to the 90\% along the crown
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                    bio.len = AlignMeshes$length,start=0.3,end=0.9)
#Extract 25 equiangular semilandmarks from each cross-section (anticlockwise)
Shape<-ToothShape(Core,25,sects_vector = NULL,cent.out = "E",direction="a")
Tooth2Dmap(Shape,AlignMeshes,rem.out =TRUE,scale=FALSE,smooth = FALSE,aspect = 0.5,gamMap = FALSE,
           nrow = 100,ncol = 100,gdl = 250,method="equiangular")

#Map of the root
AlignMeshes<-ToothAlignment(mesh1=Enamel,mesh2=Dentin,mesh3=Pulp,set,outline,analyse = "r")
#Virtual sectioning dentine-pulp
External<-AlignMeshes$almesh2$mesh
Internal<-AlignMeshes$almesh3$mesh
#Define 16 cross-sections from the 10\% to the 50\% along the root
Core<-ToothCore(External,Internal,num.points = 1000,num.sect =16,
                    bio.len = AlignMeshes$length,start=0.1,end=0.5)
#Extract 25 equiangular semilandmarks from each cross-section (anticlockwise)
Shape<-ToothShape(Core,25,sects_vector = NULL,cent.out = "E",direction="a")
Tooth2Dmap(Shape,AlignMeshes,rem.out =FALSE,scale=FALSE,smooth = FALSE,aspect = 0.5,gamMap = FALSE,
           nrow = 100,ncol = 100,gdl = 250,method="equiangular")
}
}
\author{
Antonio Profico; Mathilde Augoyard
}
