% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indTest.R
\name{indTest}
\alias{indTest}
\title{Complete Independent Test}
\usage{
indTest(X, covMat = NULL, alpha = 0.05)
}
\arguments{
\item{X}{A numeric matrix or data frame containing the measurements on the variables.}

\item{covMat}{Optional. A numeric matrix representing the population covariance matrix used in the test. If NULL, the sample covariance matrix is used (default is NULL).}

\item{alpha}{The significance level for the test (default is 0.05).}
}
\value{
A data frame containing the observed value of the test statistic, degrees of freedom, alpha value, p-value, and test result.
#' @references
Marques, F. J., Diogo, J., Norouzirad, M., & Bispo, R. (2023). Testing the independence of variables for specific covariance structures: A simulation study. Mathematical Methods in the Applied Sciences, 46(9), 10421–10434. DOI: 10.1002/mma.9130
}
\description{
Performs an independent test for a set of variables both for low and high dimensional data.
}
\examples{
# Example usage:

library(MASS)

n = 50 # Sample Size
p = 5  # number of variables
rho = 0.4
# Building a Covariance structure with Autoregressive structure
cov_mat <- covMatAR(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test assuming that the population covariance matrix is unknown
indTest(data)
# Performing the test assuming that the population covariance matrix is known
indTest(data, covMat = cov_mat)

# Example for data with missing values
# Generating data with 10\% of missing values
missing_rate <- 0.1
missing_index_row <- sample(1:n, size = round(n * missing_rate))
missing_index_col <- sample(1:p, size = 1)
data[missing_index_row, missing_index_col] <- NA # Introducing missing values
# Performing the test assuming that the population covariance matrix is unknown
indTest(data)
# Performing the test assuming that the population covariance matrix is known
indTest(data, covMat = cov_mat)

# Building a Covariance structure with Compound Symmetry structure
cov_mat <- covMatCS(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test assuming that the population covariance matrix is unknown
indTest(data)
# Performing the test assuming that the population covariance matrix is known
indTest(data, covMat = cov_mat)

# Building a Covariance structure with Circular structure
cov_mat <- covMatC(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test assuming that the population covariance matrix is unknown
indTest(data)
# Performing the test assuming that the population covariance matrix is known
indTest(data, covMat = cov_mat)


}
