% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_functions.R
\name{parsePriorParameters}
\alias{parsePriorParameters}
\title{(Internal) Parse prior parameters from viable sources}
\usage{
parsePriorParameters(
  config_theta,
  simulation_constants,
  prior_density_override,
  prior_par_override
)
}
\arguments{
\item{config_theta}{a list containing theta estimation configurations.}

\item{simulation_constants}{a named list containing simulation constants.}

\item{prior_density_override}{(optional) if supplied, treated as \code{RAW} distribution densities and overrides config values.}

\item{prior_par_override}{(optional) if supplied, treated as \code{NORMAL} distribution parameters and overrides config values.}
}
\value{
\code{\link{parsePriorParameters}} returns a named list containing:
\describe{
  \item{\code{prior_dist}}{the type of distribution. One of \code{NORMAL, UNIFORM, RAW}.}
  \item{\code{prior_par}}{an examinee-wise list containing prior parameters.}
}
}
\description{
\code{\link{parsePriorParameters}} is an internal function for parsing prior parameters from viable sources
}
\keyword{internal}
