# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' height estimation
#'
#' height estimation based on diameter in breast height and species using a
#' Petterson-function
#'
#' @param sp vector of species code for biomass function from interval [1;18];
#' see \code{\link{BaMap}} for mapping of species model codes
#' @param d13 vector of diameter in breast height; in centimeter
#' @return a scalar: tree height
#' @export
petterson <- function(sp, d13) {
    .Call(`_TapeS_petterson`, sp, d13)
}

#' Prediction of above-ground biomass according to NFI-functions
#'
#' Prediction of total above-ground biomass for trees defined via species, dbh,
#' d03 and height
#' @param spp vector of species code for biomass function [1;18]
#' @param d13 vector of diameter in breast height in centimeter
#' @param d03 vector of diameter in 30\% of tree height in centimeter
#' @param h vector of height of trees
#' @return a vector of total above-ground biomass
#' @details code taken from BDAT (Koeff.f).
#' @references
#' Riedel, T. and G. Kaendler (2017). "Nationale Treibhausgasberichterstattung:
#' Neue Funktionen zur Schätzung der oberirdischen Biomasse am Einzelbaum."
#' Forstarchiv 88(2): 31-38.
#' @export
biomass <- function(spp, d13, d03, h) {
    .Call(`_TapeS_biomass`, spp, d13, d03, h)
}

#' Component biomass functions
#'
#' evaluation of the component biomass functions fit by nonlinear seemingly
#' unrelated regression (NSUR) to estimate absolute or relative component mass
#'
#' @param spp vector of species code for biomass component function of interval
#' [1;8]; see \code{\link{BaMap}} for mapping of species model codes
#' @param dbh vector of diameter in breast height; in centimeter
#' @param ht vector of tree heights, in meter
#' @param sth vector of stump heights, in meter
#' @param d03 vector if diameter in 30\% of tree height, in centimeter
#' @param kl vector of crown length, i.e. tree height minus height of crown base, in meter
#' @return a numeric matrix holding component biomass
#' @details function to calculate component biomass; functions fitted using
#' same methodology as in Vonderach et al. (2018) with slightly updated
#' parameters as in Vonderach and Kändler (2021); species mapping as in
#' \code{TapeS::BaMap(, type=7)};
#' @references Vonderach, C., G. Kändler and C. F. Dormann (2018).
#' "Consistent set of additive biomass functions for eight tree species in
#' Germany fit by nonlinear seemingly unrelated regression."
#' Annals of Forest Science 75(2): 49.
#' \doi{10.1007/s13595-018-0728-4}
#'
#' Vonderach, C. and G. Kändler (2021). Neuentwicklung von Schaftkurven- und
#' Biomassemodellen für die Bundeswaldinventur auf Basis des TapeR-Pakets -
#' Abschlussbericht zum Projekt BWI-TapeR. Freiburg: 150p.
#' @examples
#' nsur(spp = c(1, 6),
#'      dbh = c(30, 30),
#'      ht = c(25, 27),
#'      sth = c(0.25, 0.27),
#'      d03 = c(27, 27),
#'      kl = .7*c(25, 27))
#' @export
nsur <- function(spp, dbh, ht, sth, d03, kl) {
    .Call(`_TapeS_nsur`, spp, dbh, ht, sth, d03, kl)
}

#' Component biomass functions
#'
#' evaluation of the component biomass functions fit by nonlinear seemingly
#' unrelated regression (NSUR) to estimate absolute or relative component mass
#'
#' @param spp vector of species code for biomass component function of interval
#' [1;8]; see \code{\link{BaMap}} for mapping of species model codes
#' @param dbh vector of diameter in breast height; in centimeter
#' @param ht vector of tree heights, in meter
#' @return a numeric matrix holding component biomass
#' @details simple function from Vonderach et al. (2018) to calculate component
#' biomass; species mapping as in \code{TapeS::BaMap(, type=7)}
#' @references Vonderach, C., G. Kändler and C. F. Dormann (2018).
#' "Consistent set of additive biomass functions for eight tree species in
#' Germany fit by nonlinear seemingly unrelated regression."
#' Annals of Forest Science 75(2): 49.
#' \doi{10.1007/s13595-018-0728-4}
#'
#' @examples
#' nsur2(spp = c(1, 6),
#'       dbh = c(30, 30),
#'       ht = c(25, 27))
#' @export
nsur2 <- function(spp, dbh, ht) {
    .Call(`_TapeS_nsur2`, spp, dbh, ht)
}

spline_basis <- function(knots, order, xvals, derivs) {
    .Call(`_TapeS_spline_basis`, knots, order, xvals, derivs)
}

#' diameter prediction E[d] for TapeR-object
#'
#' Prediction diameter (no variances) for given tree and TapeR-object using
#' BSpline Matrix all in C++
#' @param xm relative height of measured diameter
#' @param ym measured diameter for calibration
#' @param xp relative height for which diameter prediction is required
#' @param par a TapeR-object (including padded knots vector)
#' @param RV numeric vector holding assumed residual variance for each observation
#' @return a list holding several elements, perspectively only the estimated diameter
#' @details code implementation in C++ following the code base of TapeR. Bspline
#'   matrix code taken from R-package splines to avoid the need of calling R from C.
#' @export
lmeSKEBLUP <- function(xm, ym, xp, par, RV) {
    .Call(`_TapeS_lmeSKEBLUP`, xm, ym, xp, par, RV)
}

