% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabaTest.R
\name{taba.test}
\alias{taba.test}
\title{Robust Correlation Test}
\usage{
taba.test(x, y, method = c("taba", "tabarank", "tabwil", "tabwilrank"),
          alternative = c("less", "greater", "two.sided"),
          omega, alpha = 0.05)
}
\arguments{
\item{x}{A numeric vector of length greater than 2 must be same length as y}

\item{y}{A numeric vector of length greater than 2 must be same length as x}

\item{method}{A character string of \code{"taba"}, \code{"tabarank"}, \code{"tabwil"}, or
\code{"tabwilrank"} determining if one wants to calculate Taba linear, Taba rank
(monotonic), TabWil, or TabWil rank correlation, respectively. If no method is specified,
the function will output Taba Linear correlation.}

\item{alternative}{Character string specifying the alternative hypothesis must be one
of \code{"less"} for negative association, \code{"greater"} for
positive association, or \code{"two.sided"} for difference in association.
If the alternative is not specified, the function will default to a two sided test.}

\item{omega}{Numeric allowing the user to alter the tuning constant. If one is not specified,
the function will default to 0.45 for Taba and Taba rank, and 0.1 for TabWil and TabWil rank.
Range is between 0 and 1.}

\item{alpha}{Type I error rate. Numeric must be between 0 and 1. Default set to 0.05.}
}
\value{
This function returns the robust linear or monotonic association
  between two numeric vectors, along with it's respective test statistic, and p-value.
}
\description{
Tests the association between two numeric vectors using Taba robust linear,
   Taba rank (monotonic), TabWil, or TabWil rank correlation coefficient.
}
\details{
This function tests the association of two non-empty numeric vectors of
   length greater than two, or two columns of a data frame or matrix composed
   of more than two numeric elements. Covariates are combined colomn-wise and can be
   numeric vectors, matricies, or data frames with numeric cells. Each column in the
   matrix or data frame will be treated as a different covariate, and must have
   different names. Missing values in either x or y are deleted row-wise. The two sided
   test with the null hypothesis correlation is equal to zero. The default is a two
   sided test using Taba Linear correlation, with tuning constant \code{omega}.
}
\examples{
x = rnorm(10)
y = rnorm(10)
taba.test(x, y)
taba.test(x, y, method = "tabarank", alternative = "less")$p.value
taba.test(x, y, method = "tabwil", omega = .1)
}
\references{
Tabatabai, M., Bailey, S., Bursac, Z. et al. An introduction to new robust linear
  and monotonic correlation coefficients. BMC Bioinformatics 22, 170 (2021). https://doi.org/10.1186/s12859-021-04098-4
  \cr{\cr{\doi{https://doi.org/10.1186/s12859-021-04098-4}}}
}
\seealso{
\code{\link{taba}} for calculating Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.partial}} for partial and semipartial correlations
  \cr\code{\link{taba.gpartial}} for generalized partial correlations
  \cr\code{\link{taba.matrix}} for calculating correlation, p-value, and distance matricies
}
