% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalitionweightedshapleyvalue.R
\name{coalitionweightedshapleyvalue}
\alias{coalitionweightedshapleyvalue}
\title{Coalition-weighted Shapley value}
\usage{
coalitionweightedshapleyvalue(v, delta, binary = FALSE, game = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{delta}{A weight family. It can be introduced in two different ways: as a non-negative vector whose length is the number of coalitions (thus specifying all coalition weights) or as a non-negative vector whose length is the number of players (thus specifying the weights of single-player coalitions and implying that the rest of weights are 0). In any case, if the introduced weights do not add up to 1, the weight family is computed by normalization.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} and \code{delta} (assuming \code{delta} was introduced by specifying all coalition weights; otherwise there is no difference) are introduced in binary order instead of lexicographic order.}

\item{game}{A logical value. By default, \code{game=FALSE}. If set to \code{TRUE}, the coalition-weighted game is also returned.}
}
\value{
The coalition-weighted Shapley value, as a vector. If \code{game=TRUE}, the coalition-weighted game is also returned, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game and a weight family, this function returns the coalition-weighted Shapley value.
}
\details{
A weight family is a collection of \eqn{2^{|N|}-1} real numbers \eqn{\delta=\{\delta_{T}\}_{T \in 2^{N} \setminus \emptyset}} such that \eqn{\delta_{T} \geqslant 0} for each \eqn{T \in 2^{N} \setminus \emptyset} and \eqn{\sum_{T \in 2^{N} \setminus \emptyset}\delta_{T}=1}.
For each \eqn{v \in G^{N}} and each \eqn{T \in 2^{N}}, the T-marginal game of \eqn{v}, denoted \eqn{v^{T} \in G^{N}}, is defined as
\deqn{v^{T}(S)=v(S \cup (N \setminus T))-v(N \setminus T)+v(S \cap (N \setminus T)), \ S \in 2^{N}.}
For each game \eqn{v \in G^{N}} and each weight family \eqn{\delta}, the \eqn{\delta}-weighted game \eqn{v^{\delta} \in G^{N}} is defined as
\deqn{v^{\delta} = \sum_{T \in 2^{N} \setminus \emptyset}\delta_{T}v^{T}.}
Given a game \eqn{v \in G^{N}}, its \eqn{\delta}-weighted Shapley value, \eqn{\Phi^{\delta}(v)}, is the Shapley value of the \eqn{\delta}-weighted game:
\deqn{\Phi^{\delta}(v)=Sh(v^{\delta}).}
}
\examples{
v <- c(0,0,0,0,0,0,1,0,0,1,3,4,6,8,10)
delta <- c(0.3,0.1,0,0.6,0,0,0,0,0,0,0,0,0,0,0)
coalitionweightedshapleyvalue(v, delta, binary=TRUE)

v <- c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10)
delta <- c(0.25,0.25,0.25,0.25)
a <- coalitionweightedshapleyvalue(v, delta, game=TRUE)
b <- coalitionweightedshapleyvalue(a$game, delta, game=TRUE)
c <- coalitionweightedshapleyvalue(b$game, delta, game=TRUE)
plotcoresets(rbind(v, a$game, b$game, c$game), imputations=FALSE)

# Games a, b and c have the same Shapley value:
all(sapply(list(a$value, b$value, c$value, shapleyvalue(v)),
           function(x) all.equal(x, a$value) == TRUE))
}
\references{
Sánchez Rodríguez, E., Mirás Calvo, M. A., Quinteiro Sandomingo, C., & Núñez Lugilde, I. (2024). Coalition-weighted Shapley values. \emph{International Journal of Game Theory}, 53, 547-577.
}
\seealso{
\link{marginalgame},  \link{shapleyvalue}, \link{weightedshapleyvalue}
}
