% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptd.R
\name{sptd}
\alias{sptd}
\title{Function to do sparse temporal disaggregation from \insertCite{mosley2021sparse;textual}{TSdisaggregation}.}
\usage{
sptd(Y, X, rho, aggMat, aggRatio, adaptive = FALSE)
}
\arguments{
\item{Y}{The low-frequency response series (n_l x 1 matrix).}

\item{X}{The high-frequency indicator series (n x p matrix).}

\item{rho}{The AR(1) residual parameter (strictly between -1 and 1).}

\item{aggMat}{Aggregation matrix according to 'first', 'sum', 'average', 'last' (default is 'sum').}

\item{aggRatio}{Aggregation ratio e.g. 4 for annual-to-quarterly, 3 for quarterly-to-monthly (default is 4).}

\item{adaptive}{TRUE to use adaptive lasso penalty. FALSE for lasso penalty. Default is FALSE.}
}
\value{
y	Estimated high-frequency response series (n x 1 matrix).

betaHat	Estimated coefficient vector (p x 1 matrix).

u_l	Estimated aggregate residual series (n_l x 1 matrix).
}
\description{
Used in disaggregation.R to find estimates given the optimal rho parameter.
}
\references{
\insertAllCited{}
}
\keyword{disaggregation}
\keyword{lasso}
\keyword{sparse}
\keyword{temporal}
