% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_party.R
\name{ctree_wrapper}
\alias{ctree_wrapper}
\title{ctree_wrapper}
\usage{
ctree_wrapper(response, covariates = NULL, tree_builder_parameters = list())
}
\arguments{
\item{response}{Response variable to use in ctree model.}

\item{covariates}{Covariates to use in ctree model.}

\item{tree_builder_parameters}{A named list of parameters to pass to
\link[party]{ctree}.}
}
\value{
An object of class \linkS4class{CTree}
}
\description{
A wrapper function to \link[party]{ctree}
}
\examples{
requireNamespace( "party", quietly = TRUE )
## From party::ctree() examples:
set.seed(290875)
airq <- subset(airquality, !is.na(Ozone))

## Provide response and covariates to fit ctree
ex1 <- ctree_wrapper( response = airq$Ozone,
                      covariates = subset( airq, select = -Ozone ) )

## Pass list of control parameters. Note that ctree takes a parameter called
## 'controls' (with an 's'), rather than 'control' as in rpart.
ex2 <- ctree_wrapper( response = airq$Ozone,
                      covariates = subset( airq, select = -Ozone ),
                      tree_builder_parameters = list( controls =
                                             party::ctree_control( maxdepth = 2 ) ) )
}
\seealso{
\link[party]{ctree}
}
