% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_experiments.R
\name{random_experiments}
\alias{random_experiments}
\title{Run K random experiments}
\usage{
random_experiments(
  X,
  y,
  K = 20,
  T_stop = 1,
  num_dummies = ncol(X),
  method = "trex",
  GVS_type = "EN",
  type = "lar",
  corr_max = 0.5,
  lambda_2_lars = NULL,
  early_stop = TRUE,
  lars_state_list,
  verbose = TRUE,
  intercept = FALSE,
  standardize = TRUE,
  dummy_coef = FALSE,
  parallel_process = FALSE,
  parallel_max_cores = min(K, max(1, parallel::detectCores(logical = FALSE))),
  seed = NULL,
  eps = .Machine$double.eps
)
}
\arguments{
\item{X}{Real valued predictor matrix.}

\item{y}{Response vector.}

\item{K}{Number of random experiments.}

\item{T_stop}{Number of included dummies after which the random experiments (i.e., forward selection processes) are stopped.}

\item{num_dummies}{Number of dummies that are appended to the predictor matrix.}

\item{method}{'trex' for the T-Rex selector (\doi{10.48550/arXiv.2110.06048}),
'trex+GVS' for the T-Rex+GVS selector (\doi{10.23919/EUSIPCO55093.2022.9909883}),
'trex+DA+AR1' for the T-Rex+DA+AR1 selector,
'trex+DA+equi' for the T-Rex+DA+equi selector,
'trex+DA+BT' for the T-Rex+DA+BT selector (\doi{10.48550/arXiv.2401.15796}),
'trex+DA+NN' for the T-Rex+DA+NN selector (\doi{10.48550/arXiv.2401.15139}).}

\item{GVS_type}{'IEN' for the Informed Elastic Net (\doi{10.1109/CAMSAP58249.2023.10403489}),
'EN' for the ordinary Elastic Net (\doi{10.1111/j.1467-9868.2005.00503.x}).}

\item{type}{'lar' for 'LARS' and 'lasso' for Lasso.}

\item{corr_max}{Maximum allowed correlation between any two predictors from different clusters (for method = 'trex+GVS').}

\item{lambda_2_lars}{lambda_2-value for LARS-based Elastic Net.}

\item{early_stop}{Logical. If TRUE, then the forward selection process is stopped after T_stop dummies have been included. Otherwise
the entire solution path is computed.}

\item{lars_state_list}{If parallel_process = TRUE: List of state variables of the previous T-LARS steps of the K random experiments
(necessary for warm-starts, i.e., restarting the forward selection process exactly where it was previously terminated).
If parallel_process = FALSE: List of objects of the class tlars_cpp associated with the K random experiments
(necessary for warm-starts, i.e., restarting the forward selection process exactly where it was previously terminated).}

\item{verbose}{Logical. If TRUE progress in computations is shown.}

\item{intercept}{Logical. If TRUE an intercept is included.}

\item{standardize}{Logical. If TRUE the predictors are standardized and the response is centered.}

\item{dummy_coef}{Logical. If TRUE a matrix containing the terminal dummy coefficient vectors of all K random experiments as rows is returned.}

\item{parallel_process}{Logical. If TRUE random experiments are executed in parallel.}

\item{parallel_max_cores}{Maximum number of cores to be used for parallel processing.}

\item{seed}{Seed for random number generator (ignored if parallel_process = FALSE).}

\item{eps}{Numerical zero.}
}
\value{
List containing the results of the K random experiments.
}
\description{
Run K early terminated T-Rex (\doi{10.48550/arXiv.2110.06048}) random experiments and
compute the matrix of relative occurrences for all variables and all numbers of included variables before stopping.
}
\examples{
set.seed(123)
data("Gauss_data")
X <- Gauss_data$X
y <- c(Gauss_data$y)
res <- random_experiments(X = X, y = y)
relative_occurrences_matrix <- res$phi_T_mat
relative_occurrences_matrix
}
