% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr.R
\name{plot_cor}
\alias{plot_cor}
\title{Plot Correlation Coefficients}
\usage{
plot_cor(
  r,
  n,
  method = c("pearson", "spearman", "kendall"),
  type = c("c", "cd"),
  levels = c(0.68, 0.9, 0.95, 0.999)
)
}
\arguments{
\item{r}{The observed correlation coefficient.}

\item{n}{Total number of observations (sample size).}

\item{method}{The method by which the coefficient was calculated:
\itemize{
\item "pearson": Pearson's product-moment correlation (default)
\item "spearman": Spearman's rank correlation
\item "kendall": Kendall's tau
}}

\item{type}{Choose which plot(s) to create:
\itemize{
\item "c": consonance function only (p-values across potential parameter values)
\item "cd": consonance density function only (distribution of plausible parameter values)
\item c("c", "cd"): both plots together (default)
}}

\item{levels}{Numeric vector of confidence levels to display (default: c(.68, .9, .95, .999)).
These correspond to the confidence intervals shown on the plot.}
}
\value{
A \code{ggplot2} object or plot grid from \code{cowplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Creates consonance plots (confidence curves and/or consonance density functions) for
correlation coefficients, allowing visualization of uncertainty around correlation estimates.
}
\details{
Consonance plots provide a graphical representation of the full range of confidence intervals
for correlation coefficients at different confidence levels. These plots help visualize
the uncertainty around correlation estimates and go beyond the traditional approach of
reporting only a single confidence interval (typically 95\%).

The function creates two types of visualizations:
\enumerate{
\item \strong{Consonance function} ("c"): Shows how p-values change across different possible values
of the correlation coefficient. The x-axis represents possible correlation values, and the
y-axis represents the corresponding p-values from two-sided hypothesis tests.
\item \strong{Consonance density} ("cd"): Shows the distribution of plausible values for the correlation
coefficient. This can be interpreted as showing where the "weight of evidence" is concentrated.
}

These plots are particularly useful for:
\itemize{
\item Visualizing uncertainty around correlation estimates
\item Understanding the precision of correlation estimates
\item Comparing the relative plausibility of different correlation values
\item Going beyond the binary "significant vs. non-significant" interpretation
}

These types of plots are discussed by Schweder & Hjort (2016) and Rafi & Greenland (2020).
}
\examples{
# Example 1: Basic consonance plot for Pearson correlation
# For a correlation of r = 0.45 with n = 30
plot_cor(r = 0.45, n = 30)

# Example 2: Consonance function only for Spearman correlation
plot_cor(r = 0.6, n = 25, method = "spearman", type = "c")

# Example 3: Consonance density only for Kendall's tau
plot_cor(r = 0.3, n = 40, method = "kendall", type = "cd")

# Example 4: Custom confidence levels
plot_cor(r = 0.5, n = 50, levels = c(0.5, 0.8, 0.95))

# Example 5: Saving and further customizing the plot
library(ggplot2)
p <- plot_cor(r = 0.45, n = 30)
p + theme_minimal() +
  labs(title = "Consonance Plot for Correlation r = 0.45, n = 30")

}
\references{
Schweder, T., & Hjort, N. L. (2016). Confidence, likelihood, probability:
Statistical inference with confidence distributions. Cambridge University Press.
ISBN: 9781316445051

Rafi, Z., & Greenland, S. (2020). Semantic and cognitive tools to aid statistical science:
Replace confidence and significance by compatibility and surprise. BMC Medical Research
Methodology, 20, 244. doi:10.1186/s12874-020-01105-9
}
\seealso{
Other Correlations: 
\code{\link{boot_cor_test}()},
\code{\link{corsum_test}()},
\code{\link{power_z_cor}()},
\code{\link{z_cor_test}()}

Other plotting functions: 
\code{\link{plot_pes}()},
\code{\link{plot_smd}()}
}
\concept{Correlations}
\concept{plotting functions}
