setClass("opt",
  representation(
    notraces = "logical",
    residtraces = "logical",
    selectedtraces = "vector",
    writecon = "logical",
    writespec = "logical",
    writenormspec = "logical",
    writefit = "logical",
    writefitivo = "logical",
    writedata = "logical",
    writeclperr = "logical",
    residplot = "logical",
    plot = "logical",
    minFactor = "numeric",
    output = "character",
    nnls = "logical",
    divdrel = "logical",
    noplotest = "logical",
    plotkinspec = "logical",
    algorithm = "character",
    superimpose = "vector",
    xlab = "character",
    ylab = "character",
    title = "character",
    makeps = "character",
    linrange = "numeric",
    summaryplotrow = "numeric",
    summaryplotcol = "numeric",
    iter = "numeric",
    stderrclp = "logical",
    trilinear = "logical",
    getStartTri = "logical",
    triStart = "list",
    paropt = "list",
    addfilename = "logical",
    addest = "vector",
    adddataimage = "logical",
    kinspecerr = "logical",
    xlimspec = "vector",
    ylimspec = "vector",
    ylimspecplus = "vector",
    xlim = "vector",
    specinterpol = "logical",
    specinterpolpoints = "logical",
    specinterpolseg = "numeric",
    specinterpolbspline = "logical",
    samespecline = "logical",
    normspec = "logical",
    writespecinterpol = "logical",
    nnlscrit = "list",
    nlsalgorithm = "character",
    sumnls = "logical",
    colfit = "vector",
    coldata = "vector",
    ltyfit = "numeric",
    ltydata = "numeric",
    optimmethod = "character",
    parscale = "vector",
    maxfev = "numeric",
    imagepal = "vector"
  ),
  prototype = list(
    writecon = FALSE,
    writespec = FALSE,
    writenormspec = FALSE,
    writefit = FALSE,
    writefitivo = FALSE,
    writeclperr = FALSE,
    writedata = FALSE,
    algorithm = "nls",
    residtraces = FALSE,
    noplotest = FALSE,
    residplot = FALSE,
    plotkinspec = FALSE,
    minFactor = 1 / 1024,
    plot = TRUE,
    trilinear = FALSE,
    getStartTri = TRUE,
    triStart = list(),
    addfilename = FALSE,
    adddataimage = FALSE,
    divdrel = TRUE,
    output = "ps",
    nnls = FALSE,
    superimpose = vector(),
    paropt = list(),
    title = "",
    makeps = "",
    stderrclp = FALSE,
    summaryplotrow = 3,
    summaryplotcol = 4,
    linrange = 1,
    iter = 1,
    addest = vector(),
    kinspecerr = FALSE,
    ylimspecplus = vector(),
    xlimspec = vector(),
    ylimspec = vector(),
    xlim = vector(),
    specinterpol = FALSE,
    specinterpolpoints = TRUE,
    specinterpolseg = 50,
    specinterpolbspline = FALSE,
    normspec = FALSE,
    writespecinterpol = FALSE,
    samespecline = FALSE,
    nnlscrit = list(),
    nlsalgorithm = "default",
    sumnls = TRUE,
    notraces = FALSE,
    selectedtraces = vector(),
    colfit = vector(),
    coldata = vector(),
    ltyfit = numeric(),
    ltydata = numeric(),
    optimmethod = "Nelder-Mead",
    parscale = vector(),
    maxfev = 900,
    imagepal = vector()
  )
)

setClass("kinopt", representation("opt",
  breakdown = "list",
  FLIM = "logical",
  FLIMresidimag = "logical",
  noFLIMsummary = "logical",
  writerawcon = "logical",
  plotcohcolspec = "logical",
  kinspecest = "logical",
  writeplaincon = "list",
  plotpulsefol = "logical",
  ylimcomp = "vector"
),
prototype = list(
  breakdown = list(),
  writerawcon = FALSE,
  plotcohcolspec = TRUE,
  addest = c("kinpar"),
  FLIM = FALSE,
  FLIMresidimag = TRUE,
  noFLIMsummary = FALSE,
  paropt = par(
    mgp = c(1.5, 1, 0),
    mai = c(0.5, 0.6, .5, 0.5), mar = c(3, 3, 4, 1)
  ),
  xlab = "time",
  ylab = "wavelength",
  kinspecest = FALSE,
  writeplaincon = list(),
  plotpulsefol = FALSE,
  ylimcomp = vector()
)
)

setClass("massopt", representation("kinopt",
  axis.by = "numeric",
  scale.concen = "logical", nummaxtraces = "numeric"
),
prototype = list(
  normspec = TRUE, axis.by = 30, scale.concen = TRUE,
  nummaxtraces = 0
)
)

setClass("specopt", representation("opt",
  nospectra = "logical",
  selectedspectra = "vector"
),
prototype =
  list(
    nospectra = FALSE, selectedspectra =
      vector(), xlab = "wavelength", ylab =
      "time"
  )
)
