% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROCAnalysis.R
\name{ROCAnalysis}
\alias{ROCAnalysis}
\title{ROC Analysis}
\usage{
ROCAnalysis(Obj, plot = TRUE)
}
\arguments{
\item{Obj}{An object of class TGST.}

\item{plot}{Logical parameter indicating if ROC curve should be plotted. Default is \code{plot=TRUE}. If false, then only AUC is calculated.}
}
\value{
AUC (the area under ROC curve) and ROC curve.
}
\description{
This function performs ROC analysis for tripartite rules. If \eqn{plot=TRUE}, the ROC curve is returned.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
lambda = 0.5
Obj = TGST(Z, S, phi, method="nonpar")
ROCAnalysis(Obj, plot=TRUE)
}
\keyword{ROC}
