% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{EstDynamics}
\alias{EstDynamics}
\alias{EstDynamics2}
\title{Estimate TE dynamics using mismatch data}
\usage{
EstDynamics(mismatch, len, r = 0.013, perturb = 2, rateRange = NULL,
  plotFit = FALSE, plotSensitivity = FALSE, pause = plotFit &&
  plotSensitivity, main = sprintf("n = \%d", n))

EstDynamics2(mismatch, len, r = 0.013, nTrial = 10L, perturb = 2,
  rateRange = NULL, plotFit = FALSE, plotSensitivity = FALSE,
  pause = plotFit && plotSensitivity, ...)
}
\arguments{
\item{mismatch}{A vector containing the number of mismatches.}

\item{len}{A vector containing the length of each element.}

\item{r}{Mutation rate (substitutions/(million year * site)) used in the calculation.}

\item{perturb}{A scalar multiple to perturb the estimated death rate from the null hypothesis estimate. Used to generate the sensitivity analysis.}

\item{rateRange}{A vector of death rates, an alternative to \code{perturb} for specifying the death rates.}

\item{plotFit}{Whether to plot the distribution fits.}

\item{plotSensitivity}{Whether to plot the sensitivity analysis.}

\item{pause}{Whether to pause after each plot.}

\item{main}{The title for the plot.}

\item{nTrial}{The number of starting points for searching for the MLE.}

\item{...}{Pass to EstDynamics}
}
\value{
\code{EstDynamics} returns a \code{TEfit} object, containing the following fields, where the unit for time is million years ago (Mya):
\item{pvalue}{The p-value for testing H_0: The insertion rate is uniform over time.}
\item{ageDist}{A list containing the estimated age distributions.}
\item{insRt}{A list containing the estimated insertion rates.}
\item{agePeakLoc}{The maximum point (in age) of the age distribution. }
\item{insPeakLoc}{The maximum point (in time) of the insertion rate.}
\item{estimates}{The parameter estimates from fitting the distributions; see References}
\item{sensitivity}{A list containing the results for the sensitivity analysis, with fields \code{time}: time points; \code{delRateRange}: A vector for the range of deletion rates; \code{insRange}: A matrix whose columns contain the insertion rates under different scenarios.}
\item{n}{The sample size.}
\item{meanLen}{The mean of element length.}
\item{meanDiv}{The mean of divergence.}
\item{KDE}{A list containing the kernel density estimate for the mismatch data. }
\item{logLik}{The log-likelihoods of the parametric fits.}

This function returns a \code{TEfit2} object, containing all the above fields for \code{TEfit} and the following:
\item{estimates2}{The parameter estimates from fitting the mixture distribution.}
\item{ageDist2}{The estimated age distribution from fitting the mixture distribution.} 
\item{insRt2}{The estimated insertion rate from fitting the mixture distribution.} 
\item{agePeakLoc2}{Maximum point(s) for the age distribution.}
\item{insPeakLoc2}{Maximum point(s) for the insertion rate.}
}
\description{
Given the number of mismatches and element lengths for an LTR retrotransposon family, estimate the age distribution, insertion rate, and deletion rates.
}
\details{
\code{EstDynamics} estimates the TE dynamics through fitting a negative binomial fit to the mismatch data, while \code{EstDynamics2} uses a mixture model. For detailed implementation see References.
}
\examples{
# Analyze Gypsy family 24 (Nusif)
data(AetLTR)
dat <- subset(AetLTR, GroupID == 24 & !is.na(Chr))
set.seed(1)
res1 <- EstDynamics(dat$Mismatch, dat$UngapedLen, plotFit=TRUE, plotSensitivity=FALSE, pause=FALSE)

# p-value for testing a uniform insertion rate
res1$pvalue


# Use a mixture distribution to improve fit
res2 <- EstDynamics2(dat$Mismatch, dat$UngapedLen, plotFit=TRUE)

# A larger number of trials is recommended to achieve the global MLE
\dontrun{
res3 <- EstDynamics2(dat$Mismatch, dat$UngapedLen, plotFit=TRUE, nTrial=1000L)
}
}
\references{
\cite{Dai, X., Wang, H., Dvorak, J., Bennetzen, J., Mueller, H.-G. (2018). "Birth and Death of LTR Retrotransposons in Aegilops tauschii". Genetics}
}
