% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item.influence.R
\name{item.influence}
\alias{item.influence}
\title{Estimating item influence measures.}
\usage{
item.influence(model, data, fullcorrelation = FALSE, progress = TRUE)
}
\arguments{
\item{model}{a previously calibrated model; an object of class \code{gdina}.}

\item{data}{a required \eqn{N \times I} matrix. Binary item responses are in the columns.}

\item{fullcorrelation}{optional logical argument indicating a full or reduced response-classification correlation matrix.}

\item{progress}{An optional logical indicating whether the function should print the progress of estimation.}
}
\value{
A list containing several item influence measures.
}
\description{
Function to estimate estimate item influence measures. Code adapted from (Jurich & Madison, 2023).
This function is not available for longitudinal DCMs.
}
\details{
For DCMs, item influence quantifies how much an item impacts classifications. Given an estimated DCM and item response data, this function estimates five item influence measures, including
item pull, item override, proportion of attribute information, response-classification correlation (corr1), and response-posterior correlation (corr2).
}
\note{
Currently, this function currently only runs on DCMs estimated at a single time point. It will not run properly for TDCM objects.
}
\examples{
\donttest{
## Item influence illustration
#load data (simulated based on Jurich and Bradshaw (2014))
qmatrix <- CDM::data.sda6$q.matrix
responses <- CDM::data.sda6$data

#Estimate the full LCDM
model1 <- CDM::gdina(responses, qmatrix, linkfct = "logit", method = "ML")

#Estimate item influence measures
influence <- TDCM::item.influence(model1, responses)

#Summarize influence statistics
influence$Pull #item pull
influence$Override #item override
influence$Information #proportion of attribute information
influence$Correlation1 #correlation of responses and classifications
influence$Correlation2 #correlation of responses and posterior probabilities

}

}
\references{
Jurich, D. & Madison, M. J. (2023). Measuring item influence for diagnostic classification models. \emph{Educational Assessment}.
}
