% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_10_3.R
\docType{data}
\name{blcaOutputExamples}
\alias{blcaOutputExamples}
\title{TCGAretriever Examples}
\format{
A list including 7 elements.
\describe{
  \item{exmpl_1}{data.frame (dimensions: 10 by 13). Sample output of the `get_cancer_studies()` function.}
  \item{exmpl_2}{data.frame (dimensions: 10 by 5). Sample output of the `get_cancer_types()` function.}
  \item{exmpl_3}{data.frame (dimensions: 9 by 5). Sample output of the `get_case_lists()` function.}
  \item{exmpl_4}{list including 9 elements. Sample output of the `expand_cases()` function.}
  \item{exmpl_5}{data.frame (dimensions: 10 by 94). Sample output of the `get_clinical_data()` function.}
  \item{exmpl_6}{data.frame (dimensions: 9 by 8). Sample output of the `get_genetic_profiles()` function.}
  \item{exmpl_7}{data.frame (dimensions: 10 by 3). Sample output of the `get_gene_identifiers()` function.}
  \item{exmpl_8}{data.frame (dimensions: 2 by 10). Sample output of the `get_molecular_data()` function.}
  \item{exmpl_9}{data.frame (dimensions: 6 by 27). Sample output of the `get_mutation_data()` function.}
}
}
\usage{
data(blcaOutputExamples)
}
\description{
A list of objects including examples of the output returned by 
different `TCGAretriever` functions. The objects were obtained
from the `"blca_tcga"` study (bladder cancer).
}
\details{
The object was built using the following lines of code.
\code{
blcaOutputExamples <- list(
  exmpl_1 = head(get_cancer_studies(), 10),
  exmpl_2 = head(get_cancer_types(), 10),
  exmpl_3 = head(get_case_lists("blca_tcga"), 10)  ,
  exmpl_4 = expand_cases("blca_tcga"),
  exmpl_5 = head(get_clinical_data("blca_tcga"), 10),
  exmpl_6 = head(get_genetic_profiles("blca_tcga") , 10),
  exmpl_7 = head(get_gene_identifiers(), 10), 
  exmpl_8 = get_molecular_data(case_list_id = 'blca_tcga_3way_complete',
                               gprofile_id = 'blca_tcga_rna_seq_v2_mrna',
                               glist = c("TP53", "E2F1"))[, 1:10],
  exmpl_9 = head(get_mutation_data(case_list_id = 'blca_tcga_sequenced',
                                   gprofile_id = 'blca_tcga_mutations',
                                   glist = c('TP53', 'PTEN'))))
}
}
\examples{
data(blcaOutputExamples)
blcaOutputExamples$exmpl_1

}
\keyword{datasets}
