% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_priors.R
\name{model_priors}
\alias{model_priors}
\title{Prior model probability}
\usage{
model_priors(fullModel, discreteSurv = TRUE, modelPrior = "flat")
}
\arguments{
\item{fullModel}{formula of the model including all potential variables}

\item{discreteSurv}{Boolean var telling us whether a 'simple' multinomial
regression is looked for or if the goal is a discrete survival-time model
for multiple modes of failure is needed.}

\item{modelPrior}{what prior should be used on the model space?
\code{modelPrior} should be included in \{\code{'flat','dependent'}\}
where \code{'flat'} means a uniform pior and \code{'dependent'} sets a
multiplicity-corrected model prior on the model space.}
}
\value{
a numerical vector with the prior model probabilities
}
\description{
This function computes the prior model probabilities of the candidate
models
}
\examples{
# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here we define time as a spline with 3 knots

priors <- model_priors(fullModel = FULL, discreteSurv = TRUE,
                       modelPrior = 'dependent')
}
\author{
Rachel Heyard
}
