\name{Genotypic_Correlation_app}
\alias{Genotypic_Correlation_app}
\title{Genotypic Correlation}
\description{
\code{Genotypic_Correlation_app()} function opens an interactive and user-friendly Shiny application that enables users to compute genotypic correlation coefficients among multiple traits from experimental data.
}
\usage{
Genotypic_Correlation_app()
}
\details{
The application is designed to perform genotypic correlation analysis across multiple traits using experimental data.

Users can upload an Excel file (.xlsx or .xls) containing observations for several genotypes and traits. After uploading the file, users need to click the "Analyze" button.

The output is presented as a matrix showing the genotypic correlation coefficients between traits. A significance indication is provided along with an option to visualize the matrix as a heatmap plot.

 \strong{The correlation table can be downloaded in CSV format, and the heatmap plot as an image in JPEG and PNG format}

\strong{Note:} The analysis is based on the Randomized Block Design (RBD).
}
\section{Data Format}{
The uploaded Excel file should be formatted as follows:

\itemize{
  \item First column: Replication
  \item Second column: Genotypes
  \item Subsequent columns: Trait values (e.g., DBH, PH, FW, SW, KW, OC)
}

Trait names should be concise. Example:
\itemize{
  \item DBH : Diameter at Breast Height
  \item PH : Plant Height
  \item FW : Fruit Weight
  \item SW : Seed Weight
  \item KW : Kernel Weight
  \item OC : Oil Content
}

\strong{Note:} The uploaded file name should not contain spaces. For example, use \code{Sample_Data.xlsx} instead of \code{Sample Data.xlsx}.

An example Excel file is available for download using the \code{Download Example Data} button within the application.

The example dataset includes:
\itemize{
  \item 170 genotypes
  \item 3 replications for each genotype
  \item 6 traits: DBH, PH, FW, SW, KW, OC
}
}

\value{
Opens a user-friendly interactive Shiny application for performing genotypic correlation analysis.
}

\references{
Singh, R. K., & Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis.\cr
Dewey, D. R., & Lu, K. H. (1959). A Correlation and Path-Coefficient Analysis of Components of Crested Wheatgrass Seed Production.Agronomy Journal, 51(9), 515-518.\cr
Rajarajan, K., & K. Ganesamurthy(2014). Genetic diversity of sorghum [Sorghum bicolor (L.)] germplasm for drought tolerance. Range Management and Agroforestry, 35(2), 256-262.


}
\examples{
if(interactive()) Genotypic_Correlation_app()
}
