% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.repo.R
\name{git.repo}
\alias{git.repo}
\title{Git Repo}
\usage{
git.repo(path = ".", owner = FALSE, warn = FALSE)
}
\arguments{
\item{path}{top directory of a Git repository.}

\item{owner}{whether to include the repository owner name.}

\item{warn}{whether to generate a warning if no \verb{.git/config} file is
found.}
}
\value{
String of the format \code{"[owner]/repo"}.
}
\description{
Read the Git repository name from the \code{.git} folder.
}
\examples{
\dontrun{
git.repo()
git.repo(owner=TRUE)
}

}
\seealso{
\code{\link{draft.readme}} calls \code{git.repo} to include the repository
name in the \verb{README.md}.

\code{\link{TAF-package}} gives an overview of the package.
}
