% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-control-par.R
\name{parallel_start}
\alias{parallel_start}
\alias{parallel_stop}
\title{Start parallel clusters / plans}
\usage{
parallel_start(
  ...,
  .method = c("parallel", "spark", "future"),
  .export_vars = NULL,
  .packages = NULL
)

parallel_stop()
}
\arguments{
\item{...}{Parameters passed to underlying functions (See Details Section)}

\item{.method}{The method to create the parallel backend. Supports:
\itemize{
\item "future"   - Uses the \code{future} package; foreach bridged via \code{doFuture}
\item "parallel" - Uses the \code{parallel} + \code{doParallel} packages
\item "spark"    - Uses the \code{sparklyr} package
}}

\item{.export_vars}{Environment variables that can be sent to the workers (not needed for "future")}

\item{.packages}{Packages that can be sent to the workers (auto-handled by "future")}
}
\description{
Start parallel clusters / plans
}
\details{
\subsection{future (\code{.method = "future"})}{

Sets a \code{future::multisession} plan (portable across OSes) and registers a foreach
backend via \code{doFuture::registerDoFuture()}. This avoids the \code{tune} foreach/future warning.
\itemize{
\item Pass the first unnamed \code{...} argument as worker count (numeric) or omit to
default to \code{parallelly::availableCores(logical = FALSE)} or 2 if unknown.
}
}

\subsection{parallel (\code{.method = "parallel"})}{
\enumerate{
\item \code{parallel::makeCluster(...)}  2) \code{doParallel::registerDoParallel(cl)}
\item Set \code{.libPaths()} on workers; optional \code{clusterExport} and package loads.
}
}

\subsection{spark (\code{.method = "spark"})}{

Requires \code{sparklyr::spark_connect()}; registers foreach via \code{sparklyr::registerDoSpark(...)}.
}
}
\examples{

# Starts 2 clusters
parallel_start(2)

# Returns to sequential processing
parallel_stop()



}
