% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlabelRes.R
\name{rlabelRes}
\alias{rlabelRes}
\alias{rlabelRes.ppp}
\alias{rlabelRes.ppplist}
\alias{rlabelRes.hyperframe}
\title{Random Re-Labelling Envelope Residual}
\usage{
rlabelRes(x, ...)

\method{rlabelRes}{ppp}(x, ...)

\method{rlabelRes}{ppplist}(x, ...)

\method{rlabelRes}{hyperframe}(x, ...)
}
\arguments{
\item{x}{see \strong{Usage}}

\item{...}{arguments of function \link[spatstat.explore]{envelope.ppp},
other than parameters \code{simulate},
\code{savefuns} and \code{verbose}}
}
\description{
Random Re-Labelling Envelope Residual
}
\examples{
set.seed(52); res1_anemones = spatstat.data::anemones |>
  rlabelRes(fun = spatstat.explore::Kmark)
set.seed(52); res1_anemones_times = spatstat.data::anemones |>
  rlabelRes(fun = spatstat.explore::Kmark, f = `*`)
stopifnot(!identical(res1_anemones, res1_anemones_times))
  
\donttest{
set.seed(52); spatstat.data::anemones |>
  rlabelRes(fun = spatstat.explore::Kmark, f = \(m1, m2) { m1*m2 }) |>
  identical(y = res1_anemones_times) |>
  stopifnot()
}

set.seed(12); res_ants = spatstat.data::ants |>
  rlabelRes(fun = spatstat.explore::Gcross)

}
\keyword{internal}
