% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_mcmcglmm_icc.R
\name{nice_mcmcglmm_icc}
\alias{nice_mcmcglmm_icc}
\title{Nice table of intraclass correlation coefficients from MCMCglmm::MCMCglmm()
model output}
\usage{
nice_mcmcglmm_icc(mcmcglmm_object, prob = NULL, decimals = NULL)
}
\arguments{
\item{mcmcglmm_object}{returned output from MCMCglmm()}

\item{prob}{probability for highest posterior density interval, similar to a
confidence interval. Default is 0.95 (if provided)}

\item{decimals}{number of decimal places to use in estimates}
}
\value{
grouped_df
}
\description{
Nice table of intraclass correlation coefficients from MCMCglmm::MCMCglmm()
model output
}
\examples{
\dontrun{
data(ae)
ae$AE_SEV_GD <- as.numeric(ae$AE_SEV_GD);
ae$Drug_1_Attribution <- 0;
ae$Drug_1_Attribution[ae$CTC_AE_ATTR_SCALE \%in\% c("Definite", "Probable", "Possible")] <- 1;
ae$Drug_2_Attribution <- 0;
ae$Drug_2_Attribution[ae$CTC_AE_ATTR_SCALE_1 \%in\% c("Definite", "Probable", "Possible")] <- 1;
prior2RE <- list(R = list(V = diag(1), fix = 1), G=list(G1=list(V=1, nu=0.02), 
   G2=list(V=1, nu=0.02)));
model1 <- MCMCglmm::MCMCglmm(Drug_1_Attribution ~ AE_SEV_GD + Drug_2_Attribution, 
   random=~ae_detail + Subject, family="categorical", data=ae, saveX=TRUE, 
   verbose=FALSE, burnin=2000, nitt=10000, thin=10, pr=TRUE, prior=prior2RE);
mcmcglmm_icc <- nice_mcmcglmm_icc(model1);
}
}
\keyword{dataframe}
