% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LFA_inference.R
\name{wrapper_LFA}
\alias{wrapper_LFA}
\title{Run LFA on diagnosis data.}
\usage{
wrapper_LFA(
  rec_data,
  topic_num,
  CVB_num = 5,
  save_data = FALSE,
  beta_prior_flag = FALSE,
  topic_weight_prior = NULL
)
}
\arguments{
\item{rec_data}{A diagnosis data frame with three columns; format data as HES_age_example; first column is individual ids, second column is the disease code;
third column is the age at diagnosis. Note for each individual, we only keep the first onset of each diseases. Therefore, if there are multiple incidences of the same disease
within each individual, the rest will be ignored.}

\item{topic_num}{Number of topics to infer.}

\item{CVB_num}{Number of runs with random initialization. The final output will be the run with highest ELBO value.}

\item{save_data}{A flag which determine whether full model data will be saved. If TRUE, a Results/ folder will be created and full model data will be saved. Default is set to be FALSE.}

\item{beta_prior_flag}{A flag if true, will use a beta prior on the topic loading. Default is set to be FALSE.}

\item{topic_weight_prior}{prior of individual topic weights, default is set to be a vector of one (non-informative)}
}
\value{
Return a list object with topic_loadings (of the best run), topic_weights (of the best run), ELBO_convergence (ELBO until convergence),
patient_list (list of eid which correspond to rows of topic_weights), ds_list (gives the ordering of diseases in the topic_loadings object), disease_number (number of total diseases), patient_number(total number of patients), topic_number (total number of topic),
,multiple_run_ELBO_compare (ELBO of each runs).
}
\description{
Run LFA on diagnosis data to infer topic loadings and topic weights. Note one run of LFA on 100K individuals would take ~30min (defualt is 5 runs and pick the best fit);
if the data set is small and the goal is to infer patient-level topic weights (i.e. assign comorbidity profiles to individuals based on the disedases),
please use loading2weights.
}
\examples{
  HES_age_small_sample <- HES_age_example[1:100,]
inference_results <- wrapper_LFA(HES_age_small_sample, topic_num = 3, CVB_num = 1)
}
