test_that("hytek toptimes RIT", {

  file <- system.file("extdata", "RIT_TopTimes_FS2021.pdf", package = "SwimmeR")

  #### test dfs ####
  df_test_swim_parse <- file %>%
    read_results() %>%
    swim_parse()

  df_test_direct <- file %>%
    read_results() %>%
    toptimes_parse_hytek(avoid_hytek_toptimes = c("xxxavoidxxx"),
                         typo_hytek_toptimes = "typo",
                         replacement_hytek_toptimes = "typo")

  #### standard ####
  df_standard <-
    structure(list(Rank = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
                            13, 14, 15, 16, 17, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
                            14, 15, 16, 17, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 2, 3, 4,
                            5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 1, 2, 3, 1, 2, 3, 4, 5, 6, 7, 1,
                            2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2,
                            3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6,
                            7, 8, 9, 10, 11, 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2,
                            1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 5,
                            6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 1, 2, 3,
                            4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 1,
                            2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1,
                            2, 3, 4, 5, 1, 2, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7,
                            8, 9, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4,
                            5, 6, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6, 1, 2,
                            3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 1, 2, 3, 4, 1, 2, 3,
                            4, 1, 2, 3, 4, 1, 2, 3, 4), Result = c("24.92", "25.01", "25.12",
                                                                   "25.14", "25.39", "25.53", "25.64", "25.83", "26.56", "26.68",
                                                                   "26.71", "27.02", "27.05", "27.06", "27.78", "28.44", "29.74",
                                                                   "53.60", "54.08", "54.73", "55.30", "55.51", "56.14", "56.16",
                                                                   "56.34", "56.41", "56.68", "57.33", "58.50", "58.57", "59.50",
                                                                   "59.98", "1:00.28", "1:00.92", "1:56.03", "2:00.75", "2:01.02",
                                                                   "2:02.77", "2:04.66", "2:05.55", "2:05.82", "2:07.08", "2:11.58",
                                                                   "2:12.73", "2:14.46", "5:17.21", "5:23.88", "5:27.47", "5:27.51",
                                                                   "5:31.26", "5:34.28", "5:39.00", "5:40.13", "6:10.05", "11:17.00",
                                                                   "11:23.60", "11:34.44", "11:45.27", "11:48.76", "18:46.25", "18:53.24",
                                                                   "19:41.43", "27.47", "28.51", "28.99", "29.93", "30.03", "31.62",
                                                                   "32.79", "59.34", "1:00.35", "1:00.83", "1:01.04", "1:03.53",
                                                                   "1:03.81", "1:04.85", "1:05.91", "1:07.94", "1:08.99", "2:08.95",
                                                                   "2:15.09", "2:15.72", "2:16.17", "2:17.11", "2:19.34", "2:24.05",
                                                                   "2:24.25", "2:25.51", "1:05.85", "1:07.16", "1:08.82", "1:12.44",
                                                                   "1:12.74", "1:13.56", "1:14.04", "1:16.44", "1:17.39", "1:18.97",
                                                                   "2:21.70", "2:23.11", "2:34.86", "2:47.12", "2:47.62", "2:53.85",
                                                                   "1:00.67", "1:01.95", "1:02.07", "1:02.20", "1:03.45", "1:03.91",
                                                                   "1:05.12", "1:06.48", "1:06.62", "1:07.70", "1:09.39", "2:19.63",
                                                                   "2:24.96", "2:30.44", "2:36.02", "2:07.59", "2:10.53", "2:16.77",
                                                                   "2:19.66", "2:22.17", "2:25.74", "2:28.74", "2:28.85", "2:29.24",
                                                                   "4:50.26", "5:15.76", "231.35", "223.50", "190.85", "188.85",
                                                                   "239.70", "221.55", "196.85", "181.45", "356.35", "351.80", "337.45",
                                                                   "298.95", "384.00", "370.90", "362.90", "278.55", "21.32", "21.46",
                                                                   "21.78", "21.79", "21.84", "22.04", "22.47", "22.54", "22.74",
                                                                   "23.09", "23.25", "23.25", "23.29", "23.33", "23.34", "23.46",
                                                                   "23.55", "23.59", "23.72", "46.35", "46.83", "47.50", "48.06",
                                                                   "48.59", "48.62", "49.01", "49.03", "49.13", "49.24", "49.26",
                                                                   "49.69", "49.83", "49.93", "51.02", "51.98", "52.28", "52.32",
                                                                   "52.42", "1:42.04", "1:45.26", "1:45.71", "1:46.03", "1:46.33",
                                                                   "1:46.92", "1:47.12", "1:50.09", "1:51.84", "1:52.14", "1:53.66",
                                                                   "4:45.89", "4:46.97", "4:48.49", "4:49.73", "4:57.94", "5:00.15",
                                                                   "5:01.63", "5:02.44", "5:03.70", "10:15.20", "10:19.91", "10:29.66",
                                                                   "10:36.04", "11:11.81", "17:02.36", "17:38.81", "23.92", "24.62",
                                                                   "25.12", "25.81", "26.67", "26.98", "27.18", "34.08", "51.89",
                                                                   "52.14", "54.13", "54.23", "55.30", "55.82", "57.61", "1:00.35",
                                                                   "1:00.49", "1:51.92", "1:53.08", "1:59.98", "2:00.03", "2:00.18",
                                                                   "2:09.75", "56.98", "58.87", "59.12", "59.85", "1:00.43", "1:01.37",
                                                                   "1:02.40", "1:02.77", "1:10.64", "2:02.03", "2:11.21", "2:13.59",
                                                                   "2:14.51", "2:17.20", "2:20.72", "50.93", "51.85", "51.97", "52.10",
                                                                   "52.57", "53.09", "53.90", "54.66", "55.32", "55.94", "1:54.73",
                                                                   "1:55.61", "1:55.77", "2:02.51", "2:08.79", "2:10.72", "1:53.57",
                                                                   "1:58.33", "1:58.46", "1:59.06", "1:59.19", "2:01.74", "2:02.83",
                                                                   "2:03.45", "2:05.10", "2:07.81", "4:07.32", "4:14.02", "4:19.28",
                                                                   "4:22.60", "4:23.44", "308.70", "283.55", "184.40", "178.55",
                                                                   "288.35", "274.19", "189.45", "145.15", "451.90", "381.75", "318.20",
                                                                   "280.05", "443.35", "419.20", "288.40", "204.55"), Name = c("Phoebe Huey",
                                                                                                                               "Kimberly Dobie", "Sydney Burgard", "Khavy Sangasy", "Elle Holland",
                                                                                                                               "Samantha Russell", "Clare Maxwell", "Devon Scott-Davis", "Elizabeth Kisker",
                                                                                                                               "Mililani Rosare", "Sydney Clifton", "Katie Taylor", "Alexi Wong",
                                                                                                                               "Gabriella Guagliardo", "Zoe Masters", "Korey Hans", "Eden Wember",
                                                                                                                               "Phoebe Huey", "Kimberly Dobie", "Khavy Sangasy", "Samantha Russell",
                                                                                                                               "Devon Scott-Davis", "Elle Holland", "Clare Maxwell", "Anna Peshenko",
                                                                                                                               "Quincy Cechini", "Sydney Burgard", "Emma Thomas", "Elizabeth Kisker",
                                                                                                                               "Katie Taylor", "Alexi Wong", "Audrey Wallach", "Gabriella Guagliardo",
                                                                                                                               "Zoe Masters", "Phoebe Huey", "Emma Thomas", "Devon Scott-Davis",
                                                                                                                               "Quincy Cechini", "Mililani Rosare", "Elizabeth Kisker", "Elle Holland",
                                                                                                                               "Zoe Masters", "Alexi Wong", "Gabriella Guagliardo", "Korey Hans",
                                                                                                                               "Quincy Cechini", "Keila Flewell", "Mililani Rosare", "Emma Thomas",
                                                                                                                               "Phoebe Huey", "Zoe Masters", "Devon Scott-Davis", "Rebecca McArthur",
                                                                                                                               "Korey Hans", "Mililani Rosare", "Quincy Cechini", "Rebecca McArthur",
                                                                                                                               "Zoe Masters", "Devon Scott-Davis", "Mililani Rosare", "Rebecca McArthur",
                                                                                                                               "Zoe Masters", "Kimberly Dobie", "Quincy Cechini", "Elle Holland",
                                                                                                                               "Alexi Wong", "Amanda Macey", "Kyra Schultz", "Korey Hans", "Quincy Cechini",
                                                                                                                               "Kimberly Dobie", "Elle Holland", "Mililani Rosare", "Amanda Macey",
                                                                                                                               "Alexi Wong", "Emma Thomas", "Elizabeth Kisker", "Sydney Clifton",
                                                                                                                               "Kyra Schultz", "Quincy Cechini", "Elle Holland", "Emma Thomas",
                                                                                                                               "Rebecca McArthur", "Amanda Macey", "Alexi Wong", "Elizabeth Kisker",
                                                                                                                               "Korey Hans", "Kyra Schultz", "Khavy Sangasy", "Anna Peshenko",
                                                                                                                               "Samantha Russell", "Clare Maxwell", "Audrey Wallach", "Katie Taylor",
                                                                                                                               "Mililani Rosare", "Sydney Burgard", "Zoe Masters", "Quincy Cechini",
                                                                                                                               "Khavy Sangasy", "Anna Peshenko", "Mililani Rosare", "Gabriella Guagliardo",
                                                                                                                               "Zoe Masters", "Kiersten Winter", "Audrey Wallach", "Phoebe Huey",
                                                                                                                               "Khavy Sangasy", "Kimberly Dobie", "Keila Flewell", "Anna Peshenko",
                                                                                                                               "Korey Hans", "Sydney Clifton", "Katie Taylor", "Eden Wember",
                                                                                                                               "Zoe Masters", "Audrey Wallach", "Keila Flewell", "Kiersten Winter",
                                                                                                                               "Kyra Schultz", "Khavy Sangasy", "Anna Peshenko", "Mililani Rosare",
                                                                                                                               "Audrey Wallach", "Quincy Cechini", "Amanda Macey", "Kiersten Winter",
                                                                                                                               "Kyra Schultz", "Korey Hans", "Mililani Rosare", "Kiersten Winter",
                                                                                                                               "Kaylea Oliver", "Anastasia Parsonage Ueda", "Taylor Stanley",
                                                                                                                               "Caitlyn Anderson", "Anastasia Parsonage Ueda", "Kaylea Oliver",
                                                                                                                               "Caitlyn Anderson", "Taylor Stanley", "Kaylea Oliver", "Anastasia Parsonage Ueda",
                                                                                                                               "Caitlyn Anderson", "Taylor Stanley", "Kaylea Oliver", "Anastasia Parsonage Ueda",
                                                                                                                               "Caitlyn Anderson", "Taylor Stanley", "Drew Scheib", "Michael Atanasoff",
                                                                                                                               "John Sapp", "Jonathan Costa", "Michael Pacholarz", "Kai Louie",
                                                                                                                               "Conor Kinley", "Aidan Daudier", "Braden Feasley", "Benjamin Sippel",
                                                                                                                               "Gerald Porretta", "Theoren Heilman", "Ryan Sweet", "Tyler Schwarz",
                                                                                                                               "Connor Shriver", "Flynn Lundeen", "Matthew Ciminelli", "Zachary Claus",
                                                                                                                               "Ronan Gorman", "Drew Scheib", "John Sapp", "Michael Atanasoff",
                                                                                                                               "Brendan Kapp", "Kai Louie", "Jonathan Costa", "Gerald Porretta",
                                                                                                                               "Zachary Claus", "Alex Pecze", "Aidan Daudier", "Braden Feasley",
                                                                                                                               "Conor Kinley", "Matthew Ciminelli", "Michael Pacholarz", "Theoren Heilman",
                                                                                                                               "Tyler Schwarz", "Ronan Gorman", "Kyle Emmerling", "Samuel Sokalzuk",
                                                                                                                               "Drew Scheib", "Kai Louie", "Michael Pacholarz", "Gerald Porretta",
                                                                                                                               "Aidan Daudier", "Theoren Heilman", "Braden Feasley", "Connor Shriver",
                                                                                                                               "Alex Pecze", "Benjamin Sippel", "Zachary Claus", "Aidan Daudier",
                                                                                                                               "Alex Pecze", "Braden Feasley", "Gerald Porretta", "Theoren Heilman",
                                                                                                                               "Samuel Sokalzuk", "Mitchell Gumbert", "Flynn Lundeen", "Kai Louie",
                                                                                                                               "Samuel Sokalzuk", "Flynn Lundeen", "Theoren Heilman", "Gerald Porretta",
                                                                                                                               "Connor Donoghue", "Theoren Heilman", "Samuel Sokalzuk", "Drew Scheib",
                                                                                                                               "Alex Pecze", "Connor Shriver", "John Sapp", "Ryan Sweet", "Michael Pacholarz",
                                                                                                                               "Tyler Schwarz", "Aidan Daudier", "John Sapp", "Alex Pecze",
                                                                                                                               "Connor Shriver", "Drew Scheib", "Michael Pacholarz", "Ryan Sweet",
                                                                                                                               "Tyler Schwarz", "Connor Donoghue", "Ronan Gorman", "Alex Pecze",
                                                                                                                               "Aidan Daudier", "Michael Pacholarz", "Connor Shriver", "Ryan Sweet",
                                                                                                                               "Tyler Schwarz", "Brendan Kapp", "Matthew Ciminelli", "Jonathan Costa",
                                                                                                                               "Benjamin Sippel", "Mitchell Gumbert", "Samuel Hart", "Conor Kinley",
                                                                                                                               "Connor Donoghue", "Ronan Gorman", "Brendan Kapp", "Benjamin Sippel",
                                                                                                                               "Samuel Hart", "Mitchell Gumbert", "Connor Donoghue", "Edrick Nguyen",
                                                                                                                               "Drew Scheib", "John Sapp", "Edrick Nguyen", "Jonathan Costa",
                                                                                                                               "Michael Atanasoff", "Kai Louie", "Ryan Sweet", "Kyle Emmerling",
                                                                                                                               "Samuel Hart", "Zachary Claus", "Drew Scheib", "Kyle Emmerling",
                                                                                                                               "Edrick Nguyen", "Samuel Sokalzuk", "Ryan Sweet", "Samuel Hart",
                                                                                                                               "Brendan Kapp", "Edrick Nguyen", "Benjamin Sippel", "Kyle Emmerling",
                                                                                                                               "Aidan Daudier", "Zachary Claus", "Jonathan Costa", "Connor Shriver",
                                                                                                                               "Connor Donoghue", "Michael Pacholarz", "Aidan Daudier", "Kyle Emmerling",
                                                                                                                               "Edrick Nguyen", "Zachary Claus", "Samuel Sokalzuk", "Gellert Kish",
                                                                                                                               "Neko Ferrara", "Alexander Beekman", "Elias Vanier", "Neko Ferrara",
                                                                                                                               "Gellert Kish", "Alexander Beekman", "Elias Vanier", "Gellert Kish",
                                                                                                                               "Neko Ferrara", "Alexander Beekman", "Elias Vanier", "Neko Ferrara",
                                                                                                                               "Gellert Kish", "Alexander Beekman", "Elias Vanier"), Age = c("SR",
                                                                                                                                                                                             "FR", "JR", "JR", "JR", "JR", "JR", "JR", "JR", "SR", "SR", "SO",
                                                                                                                                                                                             "SO", "JR", "SO", "SO", "JR", "SR", "FR", "JR", "JR", "JR", "JR",
                                                                                                                                                                                             "JR", "FR", "SO", "JR", "SO", "JR", "SO", "SO", "FR", "JR", "SO",
                                                                                                                                                                                             "SR", "SO", "JR", "SO", "SR", "JR", "JR", "SO", "SO", "JR", "SO",
                                                                                                                                                                                             "SO", "SO", "SR", "SO", "SR", "SO", "JR", "FR", "SO", "SR", "SO",
                                                                                                                                                                                             "FR", "SO", "JR", "SR", "FR", "SO", "FR", "SO", "JR", "SO", "SO",
                                                                                                                                                                                             "SO", "SO", "SO", "FR", "JR", "SR", "SO", "SO", "SO", "JR", "SR",
                                                                                                                                                                                             "SO", "SO", "JR", "SO", "FR", "SO", "SO", "JR", "SO", "SO", "JR",
                                                                                                                                                                                             "FR", "JR", "JR", "FR", "SO", "SR", "JR", "SO", "SO", "JR", "FR",
                                                                                                                                                                                             "SR", "JR", "SO", "SO", "FR", "SR", "JR", "FR", "SO", "FR", "SO",
                                                                                                                                                                                             "SR", "SO", "JR", "SO", "FR", "SO", "SO", "SO", "JR", "FR", "SR",
                                                                                                                                                                                             "FR", "SO", "SO", "SO", "SO", "SO", "SR", "SO", "FR", "SR", "FR",
                                                                                                                                                                                             "FR", "SR", "FR", "FR", "FR", "FR", "SR", "FR", "FR", "FR", "SR",
                                                                                                                                                                                             "FR", "FR", "SO", "SO", "FR", "JR", "SO", "SO", "FR", "JR", "SR",
                                                                                                                                                                                             "FR", "SO", "JR", "JR", "SR", "FR", "FR", "JR", "SO", "SO", "SO",
                                                                                                                                                                                             "FR", "SO", "JR", "SO", "JR", "SO", "SO", "SO", "JR", "SR", "FR",
                                                                                                                                                                                             "JR", "SO", "JR", "SR", "SO", "JR", "FR", "SO", "SO", "SO", "SO",
                                                                                                                                                                                             "JR", "JR", "SR", "FR", "SO", "FR", "SO", "JR", "SO", "SR", "SO",
                                                                                                                                                                                             "JR", "FR", "JR", "FR", "SO", "FR", "FR", "JR", "SO", "SO", "JR",
                                                                                                                                                                                             "FR", "SO", "SO", "FR", "FR", "JR", "SO", "SR", "JR", "FR", "SO",
                                                                                                                                                                                             "FR", "SO", "SO", "JR", "SR", "SO", "SO", "SO", "JR", "SO", "FR",
                                                                                                                                                                                             "JR", "SR", "JR", "JR", "JR", "FR", "JR", "FR", "FR", "SO", "SO",
                                                                                                                                                                                             "JR", "FR", "FR", "JR", "SO", "FR", "SO", "FR", "FR", "JR", "SO",
                                                                                                                                                                                             "SO", "JR", "JR", "FR", "SO", "SO", "JR", "FR", "FR", "JR", "FR",
                                                                                                                                                                                             "JR", "FR", "FR", "JR", "JR", "SO", "JR", "FR", "SO", "SO", "JR",
                                                                                                                                                                                             "JR", "FR", "SO", "FR", "FR", "SO", "SO", NA, "SO", "FR", "SO",
                                                                                                                                                                                             NA, "FR", "SO", "SO", NA, "SO", "FR", "SO", NA), Date = c("12/3/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "11/20/2021", "10/20/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "11/20/2021", "10/23/2021", "11/6/2021",
                                                                                                                                                                                                                                                       "10/16/2021", "12/3/2021", "10/9/2021", "10/23/2021", "10/9/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "12/3/2021", "10/9/2021", "11/6/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "11/20/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "11/6/2021", "11/20/2021", "10/20/2021", "10/16/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "11/6/2021", "10/9/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "11/20/2021", "10/9/2021", "12/3/2021", "10/20/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "10/20/2021", "10/23/2021", "10/16/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "11/20/2021", "12/3/2021", "10/20/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "12/3/2021", "11/6/2021", "11/6/2021", "10/9/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "10/20/2021", "11/6/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "11/6/2021", "11/6/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "10/16/2021", "11/6/2021", "12/3/2021", "11/20/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "11/6/2021", "12/3/2021", "10/9/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "10/23/2021", "10/16/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "10/9/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "11/6/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "12/3/2021", "10/23/2021", "10/16/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/20/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "11/6/2021", "12/3/2021", "10/9/2021", "12/3/2021", "11/20/2021",
                                                                                                                                                                                                                                                       "10/16/2021", "10/20/2021", "12/3/2021", "10/20/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/9/2021", "12/3/2021", "10/9/2021", "11/6/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/23/2021", "11/6/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "11/6/2021", "10/9/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "12/3/2021", "12/3/2021", "12/3/2021", "11/20/2021",
                                                                                                                                                                                                                                                       "10/16/2021", "11/20/2021", "11/6/2021", "10/16/2021", "11/20/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "11/20/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/16/2021", "10/9/2021", "10/16/2021", "12/3/2021", "10/16/2021",
                                                                                                                                                                                                                                                       "10/16/2021", "10/23/2021", "10/9/2021", "12/3/2021", "10/20/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "12/3/2021", "10/20/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "11/20/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "10/20/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "11/20/2021", "11/20/2021", "11/6/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/16/2021", "10/9/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "10/23/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/23/2021", "10/20/2021", "10/16/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "11/6/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/20/2021", "10/20/2021", "11/6/2021", "10/23/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "11/6/2021", "10/9/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "11/6/2021", "11/20/2021", "11/6/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "11/20/2021", "10/16/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/16/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "10/20/2021", "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "10/9/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "10/9/2021", "12/3/2021", "12/3/2021", "10/9/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "10/16/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "10/9/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "12/3/2021", "10/9/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "10/23/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "10/16/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "11/20/2021", "12/3/2021", "12/3/2021", "10/20/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "11/20/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "10/16/2021", "11/20/2021", "10/23/2021", "11/6/2021",
                                                                                                                                                                                                                                                       "10/23/2021", "10/23/2021", "12/3/2021", "12/3/2021", "12/3/2021",
                                                                                                                                                                                                                                                       "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021", "12/3/2021"
                                                                                                                                                                                             ), Meet = c("Don Richards 2021", "RPI vs RIT", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "RIT-Oswego", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Ithaca vs RIT 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "Gannon vs. RIT", "RIT vs Alfred University", "Don Richards 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Clarkson vs RIT", "RPI vs RIT", "RPI vs RIT",
                                                                                                                                                                                                         "Don Richards 2021", "RPI vs RIT", "Gannon vs. RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Ithaca vs RIT 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "Ithaca vs RIT 2021", "RIT-Oswego", "RIT vs Alfred University",
                                                                                                                                                                                                         "RPI vs RIT", "Gannon vs. RIT", "RPI vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "RIT-Oswego", "RPI vs RIT",
                                                                                                                                                                                                         "RIT-Oswego", "Clarkson vs RIT", "RIT vs Alfred University",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Don Richards 2021", "RIT-Oswego", "Don Richards 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "Don Richards 2021", "Gannon vs. RIT", "Gannon vs. RIT", "RPI vs RIT",
                                                                                                                                                                                                         "Ithaca vs RIT 2021", "RIT-Oswego", "Gannon vs. RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Gannon vs. RIT", "Gannon vs. RIT",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "RIT vs Alfred University", "Gannon vs. RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Ithaca vs RIT 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "Don Richards 2021", "RPI vs RIT", "RPI vs RIT",
                                                                                                                                                                                                         "Clarkson vs RIT", "RIT vs Alfred University", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Clarkson vs RIT", "Don Richards 2021", "Clarkson vs RIT", "RIT vs Alfred University",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "RIT-Oswego", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Gannon vs. RIT", "Don Richards 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "Ithaca vs RIT 2021", "RIT vs Alfred University",
                                                                                                                                                                                                         "RIT-Oswego", "Don Richards 2021", "RIT-Oswego", "Don Richards 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "RPI vs RIT", "Gannon vs. RIT",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "Gannon vs. RIT", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Gannon vs. RIT", "RPI vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Clarkson vs RIT", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Ithaca vs RIT 2021", "RIT vs Alfred University",
                                                                                                                                                                                                         "Ithaca vs RIT 2021", "Gannon vs. RIT", "RIT vs Alfred University",
                                                                                                                                                                                                         "Ithaca vs RIT 2021", "Ithaca vs RIT 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "RIT vs Alfred University", "RPI vs RIT",
                                                                                                                                                                                                         "RIT vs Alfred University", "Don Richards 2021", "RIT vs Alfred University",
                                                                                                                                                                                                         "RIT vs Alfred University", "Clarkson vs RIT", "RPI vs RIT",
                                                                                                                                                                                                         "Don Richards 2021", "RIT-Oswego", "Clarkson vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "RIT-Oswego", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "RIT-Oswego", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Ithaca vs RIT 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "Don Richards 2021", "RIT vs Alfred University",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Clarkson vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "RIT-Oswego", "RIT vs Alfred University", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Gannon vs. RIT", "Don Richards 2021", "RIT-Oswego",
                                                                                                                                                                                                         "RIT-Oswego", "Gannon vs. RIT", "Clarkson vs RIT", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "RPI vs RIT", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Gannon vs. RIT", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Gannon vs. RIT", "Ithaca vs RIT 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "RIT vs Alfred University", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "RIT vs Alfred University", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "RIT-Oswego", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "RPI vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "RPI vs RIT", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "RPI vs RIT", "Don Richards 2021", "Don Richards 2021", "RIT vs Alfred University",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "RPI vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Ithaca vs RIT 2021", "Don Richards 2021", "RPI vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Clarkson vs RIT", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "RIT vs Alfred University", "Don Richards 2021", "Ithaca vs RIT 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "RIT-Oswego", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Ithaca vs RIT 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "RIT vs Alfred University", "Ithaca vs RIT 2021", "Clarkson vs RIT",
                                                                                                                                                                                                         "Gannon vs. RIT", "Clarkson vs RIT", "Clarkson vs RIT", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021", "Don Richards 2021", "Don Richards 2021",
                                                                                                                                                                                                         "Don Richards 2021"), Event = c("Women 50 Free", "Women 50 Free",
                                                                                                                                                                                                                                         "Women 50 Free", "Women 50 Free", "Women 50 Free", "Women 50 Free",
                                                                                                                                                                                                                                         "Women 50 Free", "Women 50 Free", "Women 50 Free", "Women 50 Free",
                                                                                                                                                                                                                                         "Women 50 Free", "Women 50 Free", "Women 50 Free", "Women 50 Free",
                                                                                                                                                                                                                                         "Women 50 Free", "Women 50 Free", "Women 50 Free", "Women 100 Free",
                                                                                                                                                                                                                                         "Women 100 Free", "Women 100 Free", "Women 100 Free", "Women 100 Free",
                                                                                                                                                                                                                                         "Women 100 Free", "Women 100 Free", "Women 100 Free", "Women 100 Free",
                                                                                                                                                                                                                                         "Women 100 Free", "Women 100 Free", "Women 100 Free", "Women 100 Free",
                                                                                                                                                                                                                                         "Women 100 Free", "Women 100 Free", "Women 100 Free", "Women 100 Free",
                                                                                                                                                                                                                                         "Women 200 Free", "Women 200 Free", "Women 200 Free", "Women 200 Free",
                                                                                                                                                                                                                                         "Women 200 Free", "Women 200 Free", "Women 200 Free", "Women 200 Free",
                                                                                                                                                                                                                                         "Women 200 Free", "Women 200 Free", "Women 200 Free", "Women 500 Free",
                                                                                                                                                                                                                                         "Women 500 Free", "Women 500 Free", "Women 500 Free", "Women 500 Free",
                                                                                                                                                                                                                                         "Women 500 Free", "Women 500 Free", "Women 500 Free", "Women 500 Free",
                                                                                                                                                                                                                                         "Women 1000 Free", "Women 1000 Free", "Women 1000 Free", "Women 1000 Free",
                                                                                                                                                                                                                                         "Women 1000 Free", "Women 1650 Free", "Women 1650 Free", "Women 1650 Free",
                                                                                                                                                                                                                                         "Women 50 Back", "Women 50 Back", "Women 50 Back", "Women 50 Back",
                                                                                                                                                                                                                                         "Women 50 Back", "Women 50 Back", "Women 50 Back", "Women 100 Back",
                                                                                                                                                                                                                                         "Women 100 Back", "Women 100 Back", "Women 100 Back", "Women 100 Back",
                                                                                                                                                                                                                                         "Women 100 Back", "Women 100 Back", "Women 100 Back", "Women 100 Back",
                                                                                                                                                                                                                                         "Women 100 Back", "Women 200 Back", "Women 200 Back", "Women 200 Back",
                                                                                                                                                                                                                                         "Women 200 Back", "Women 200 Back", "Women 200 Back", "Women 200 Back",
                                                                                                                                                                                                                                         "Women 200 Back", "Women 200 Back", "Women 100 Breast", "Women 100 Breast",
                                                                                                                                                                                                                                         "Women 100 Breast", "Women 100 Breast", "Women 100 Breast", "Women 100 Breast",
                                                                                                                                                                                                                                         "Women 100 Breast", "Women 100 Breast", "Women 100 Breast", "Women 100 Breast",
                                                                                                                                                                                                                                         "Women 200 Breast", "Women 200 Breast", "Women 200 Breast", "Women 200 Breast",
                                                                                                                                                                                                                                         "Women 200 Breast", "Women 200 Breast", "Women 100 Fly", "Women 100 Fly",
                                                                                                                                                                                                                                         "Women 100 Fly", "Women 100 Fly", "Women 100 Fly", "Women 100 Fly",
                                                                                                                                                                                                                                         "Women 100 Fly", "Women 100 Fly", "Women 100 Fly", "Women 100 Fly",
                                                                                                                                                                                                                                         "Women 100 Fly", "Women 200 Fly", "Women 200 Fly", "Women 200 Fly",
                                                                                                                                                                                                                                         "Women 200 Fly", "Women 200 IM", "Women 200 IM", "Women 200 IM",
                                                                                                                                                                                                                                         "Women 200 IM", "Women 200 IM", "Women 200 IM", "Women 200 IM",
                                                                                                                                                                                                                                         "Women 200 IM", "Women 200 IM", "Women 400 IM", "Women 400 IM",
                                                                                                                                                                                                                                         "Women 1 Meter 6 Dives", "Women 1 Meter 6 Dives", "Women 1 Meter 6 Dives",
                                                                                                                                                                                                                                         "Women 1 Meter 6 Dives", "Women 3 Meter 6 Dives", "Women 3 Meter 6 Dives",
                                                                                                                                                                                                                                         "Women 3 Meter 6 Dives", "Women 3 Meter 6 Dives", "Women 1 Meter 11 Dives",
                                                                                                                                                                                                                                         "Women 1 Meter 11 Dives", "Women 1 Meter 11 Dives", "Women 1 Meter 11 Dives",
                                                                                                                                                                                                                                         "Women 3 Meter 11 Dives", "Women 3 Meter 11 Dives", "Women 3 Meter 11 Dives",
                                                                                                                                                                                                                                         "Women 3 Meter 11 Dives", "Men 50 Free", "Men 50 Free", "Men 50 Free",
                                                                                                                                                                                                                                         "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free",
                                                                                                                                                                                                                                         "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free",
                                                                                                                                                                                                                                         "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free", "Men 50 Free",
                                                                                                                                                                                                                                         "Men 50 Free", "Men 100 Free", "Men 100 Free", "Men 100 Free",
                                                                                                                                                                                                                                         "Men 100 Free", "Men 100 Free", "Men 100 Free", "Men 100 Free",
                                                                                                                                                                                                                                         "Men 100 Free", "Men 100 Free", "Men 100 Free", "Men 100 Free",
                                                                                                                                                                                                                                         "Men 100 Free", "Men 100 Free", "Men 100 Free", "Men 100 Free",
                                                                                                                                                                                                                                         "Men 100 Free", "Men 100 Free", "Men 100 Free", "Men 100 Free",
                                                                                                                                                                                                                                         "Men 200 Free", "Men 200 Free", "Men 200 Free", "Men 200 Free",
                                                                                                                                                                                                                                         "Men 200 Free", "Men 200 Free", "Men 200 Free", "Men 200 Free",
                                                                                                                                                                                                                                         "Men 200 Free", "Men 200 Free", "Men 200 Free", "Men 500 Free",
                                                                                                                                                                                                                                         "Men 500 Free", "Men 500 Free", "Men 500 Free", "Men 500 Free",
                                                                                                                                                                                                                                         "Men 500 Free", "Men 500 Free", "Men 500 Free", "Men 500 Free",
                                                                                                                                                                                                                                         "Men 1000 Free", "Men 1000 Free", "Men 1000 Free", "Men 1000 Free",
                                                                                                                                                                                                                                         "Men 1000 Free", "Men 1650 Free", "Men 1650 Free", "Men 50 Back",
                                                                                                                                                                                                                                         "Men 50 Back", "Men 50 Back", "Men 50 Back", "Men 50 Back", "Men 50 Back",
                                                                                                                                                                                                                                         "Men 50 Back", "Men 50 Back", "Men 100 Back", "Men 100 Back",
                                                                                                                                                                                                                                         "Men 100 Back", "Men 100 Back", "Men 100 Back", "Men 100 Back",
                                                                                                                                                                                                                                         "Men 100 Back", "Men 100 Back", "Men 100 Back", "Men 200 Back",
                                                                                                                                                                                                                                         "Men 200 Back", "Men 200 Back", "Men 200 Back", "Men 200 Back",
                                                                                                                                                                                                                                         "Men 200 Back", "Men 100 Breast", "Men 100 Breast", "Men 100 Breast",
                                                                                                                                                                                                                                         "Men 100 Breast", "Men 100 Breast", "Men 100 Breast", "Men 100 Breast",
                                                                                                                                                                                                                                         "Men 100 Breast", "Men 100 Breast", "Men 200 Breast", "Men 200 Breast",
                                                                                                                                                                                                                                         "Men 200 Breast", "Men 200 Breast", "Men 200 Breast", "Men 200 Breast",
                                                                                                                                                                                                                                         "Men 100 Fly", "Men 100 Fly", "Men 100 Fly", "Men 100 Fly", "Men 100 Fly",
                                                                                                                                                                                                                                         "Men 100 Fly", "Men 100 Fly", "Men 100 Fly", "Men 100 Fly", "Men 100 Fly",
                                                                                                                                                                                                                                         "Men 200 Fly", "Men 200 Fly", "Men 200 Fly", "Men 200 Fly", "Men 200 Fly",
                                                                                                                                                                                                                                         "Men 200 Fly", "Men 200 IM", "Men 200 IM", "Men 200 IM", "Men 200 IM",
                                                                                                                                                                                                                                         "Men 200 IM", "Men 200 IM", "Men 200 IM", "Men 200 IM", "Men 200 IM",
                                                                                                                                                                                                                                         "Men 200 IM", "Men 400 IM", "Men 400 IM", "Men 400 IM", "Men 400 IM",
                                                                                                                                                                                                                                         "Men 400 IM", "Men 1 Meter 6 Dives", "Men 1 Meter 6 Dives", "Men 1 Meter 6 Dives",
                                                                                                                                                                                                                                         "Men 1 Meter 6 Dives", "Men 3 Meter 6 Dives", "Men 3 Meter 6 Dives",
                                                                                                                                                                                                                                         "Men 3 Meter 6 Dives", "Men 3 Meter 6 Dives", "Men 1 Meter 11 Dives",
                                                                                                                                                                                                                                         "Men 1 Meter 11 Dives", "Men 1 Meter 11 Dives", "Men 1 Meter 11 Dives",
                                                                                                                                                                                                                                         "Men 3 Meter 11 Dives", "Men 3 Meter 11 Dives", "Men 3 Meter 11 Dives",
                                                                                                                                                                                                                                         "Men 3 Meter 11 Dives")), class = "data.frame", row.names = c(NA,
                                                                                                                                                                                                                                                                                                       -296L))


  #### tests ####
  expect_equivalent(df_standard, df_test_swim_parse)
  expect_equivalent(df_standard, df_test_direct)
})

# testthat::test_file("tests/testthat/test-hytek_toptimes.R")
