% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dive_place.R
\name{dive_place}
\alias{dive_place}
\title{Adds places to diving results}
\usage{
dive_place(
  df,
  score_col = Finals,
  max_place = NULL,
  keep_nonscoring = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{df}{a data frame with results from \code{swim_parse}, including only
diving results (not swimming)}

\item{score_col}{the name of a column in \code{df} containing scores on which
to place (order) performances}

\item{max_place}{highest place value that scores #' @param score_col the name
of a column in \code{df} containing scores on which to place (order)
performances}

\item{keep_nonscoring}{are athletes in places greater than \code{max_place}
be retained in the data frame.  Either \code{TRUE} or \code{FALSE}}

\item{verbose}{should warning messages be posted.  Default is \code{TRUE} and
should rarely be changed.}
}
\value{
data frame modified so that places have been appended based on diving
  score
}
\description{
Places are awarded on the basis of score, with highest score winning.  Ties
are placed as ties (both athletes get 2nd etc.)
}
\seealso{
\code{dive_place} is a helper function used inside of
  \code{results_score}
}
