% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{cross_tabulation}
\alias{cross_tabulation}
\title{Generate cross-tabulation table with chi-square test}
\usage{
cross_tabulation(data, col1, col2, weight_col = NULL)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col1}{Character string specifying first categorical variable}

\item{col2}{Character string specifying second categorical variable}

\item{weight_col}{Character string specifying column name containing weights (optional)}
}
\value{
A list containing cross-tabulation and chi-square test results
}
\description{
This function creates a cross-tabulation between two categorical variables
and performs a chi-square test of independence. Can incorporate survey weights.
}
\examples{
data <- data.frame(gender = c("M", "F", "M", "F"), 
                   education = c("HS", "College", "HS", "College"))
cross_tab <- cross_tabulation(data, "gender", "education")
}
