% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StructuralDecompose.R
\name{Smoothing}
\alias{Smoothing}
\title{Smoothening of the time series}
\usage{
Smoothing(timeseries, frequency = 52, smoothening_algorithm = "lowess", breaks)
}
\arguments{
\item{timeseries}{Given time series}

\item{frequency}{Timeseries frequency, defaults to 12 points}

\item{smoothening_algorithm}{Smoothening algorithm required}

\item{breaks}{Breakpoints identified by the previous algorithm}

\item{lowess}{Lowess smoothener}
}
\value{
The smoothened time series
}
\description{
Smoothening of the time series
}
\examples{
Smoothing(timeseries = StructuralDecompose::Nile_dataset[,1], breaks = c(4, 50, 80))

Smoothing(timeseries = runif(n = 50, min = 1, max = 10), breaks = c(4, 20, 30))
}
